% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_heterogeneity.R
\name{simulate_heterogeneity}
\alias{simulate_heterogeneity}
\title{Simulation of a compartmental infectious disease transmission model with 2 types of hosts}
\usage{
simulate_heterogeneity(S10 = 1000, I10 = 1, S20 = 1000, I20 = 0,
  tmax = 120, b11 = 0.01, b12 = 0, b21 = 0, b22 = 0, g1 = 1,
  g2 = 1, w1 = 0, w2 = 0)
}
\arguments{
\item{S10}{initial number of susceptible type 1 hosts}

\item{I10}{initial number of infected type 1 hosts}

\item{S20}{initial number of susceptible type 2 hosts}

\item{I20}{initial number of infected type 2 hosts}

\item{tmax}{maximum simulation time, units of months}

\item{b11}{rate of transmission from infected type 1 host to susceptible type 1 host}

\item{b12}{rate of transmission from infected type 1 host to susceptible type 2 host}

\item{b21}{rate of transmission from infected type 2 host to susceptible type 1 host}

\item{b22}{rate of transmission from infected type 2 host to susceptible type 2 host}

\item{g1}{the rate at which infected type 1 hosts recover}

\item{g2}{the rate at which infected type 2 hosts recover}

\item{w1}{the rate at which type 1 host immunity wanes}

\item{w2}{the rate at which type 2 host immunity wanes}
}
\value{
This function returns the simulation result as obtained from a call
  to the deSolve ode solver.
}
\description{
This model allows for the simulation of an ID with 2 types of hosts
}
\details{
A compartmental ID model with several states/compartments
  is simulated as a set of ordinary differential
  equations. The function returns the output from the odesolver as a matrix,
  with one column per compartment/variable. The first column is time.
}
\section{Warning}{

  This function does not perform any error checking. So if you try to do
  something nonsensical (e.g. any negative values or fractions > 1),
  the code will likely abort with an error message.
}

\examples{
  # To run the simulation with default parameters just call the function:
  result <- simulate_heterogeneity()
  # To choose parameter values other than the standard one, specify them like such:
  result <- simulate_heterogeneity(S10 = 100, S20 = 1e3,  tmax = 100)
  # You should then use the simulation result returned from the function, like this:
  plot(result$ts[,"Time"],result$ts[,"S1"],xlab='Time',ylab='Number Susceptible 1',type='l')
  # Consider also if we want to make the rate of transmission from infected type 1
  # host to susceptible type 1 host 0.7, and then plot the rate of infection for
  # type 1 hosts.
  result <- simulate_heterogeneity(S10 = 100, S20 = 1e3, b11 = 0.7, tmax = 100)
  plot(result$ts[,"Time"],result$ts[,"I1"],xlab="Time",ylab="Number Infected 1", type = "l")
  # We can do the same for the infection of susceptible type 2 hosts from infected
  # type 1 hosts, and plot the type 2 rate of infection.
  result <- simulate_heterogeneity(S10 = 100, S20 = 1e3, b12 = 0.7, tmax = 100)
  plot(result$ts[,"Time"],result$ts[,"I2"],xlab="Time",ylab="Number Infected 2", type = "l")
}
\references{
See e.g. Keeling and Rohani 2008 for SIR models and the
  documentation for the deSolve package for details on ODE solvers
}
\seealso{
The UI of the Shiny app 'Host Heterogeneity', which is part of this package, contains more details on the model.
}
\author{
Andreas Handel
}
