% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_modelexploration_sir.R
\name{simulate_modelexploration_sir}
\alias{simulate_modelexploration_sir}
\title{Simulation to illustrate parameter scan of the basic SIR model with births and deaths
#'}
\usage{
simulate_modelexploration_sir(
  S = 1000,
  I = 1,
  R = 0,
  b = 0.002,
  g = 1,
  m = 0,
  n = 0,
  tstart = 0,
  tfinal = 100,
  dt = 0.1,
  samples = 10,
  parmin = 5e-04,
  parmax = 0.005,
  samplepar = "b",
  pardist = "lin"
)
}
\arguments{
\item{S}{: starting value for Susceptible : numeric}

\item{I}{: starting value for Infected : numeric}

\item{R}{: starting value for Recovered : numeric}

\item{b}{: infection rate : numeric}

\item{g}{: recovery rate : numeric}

\item{m}{: the rate at which new individuals enter the model (are born) : numeric}

\item{n}{: the rate of natural death (the inverse is the average lifespan) : numeric}

\item{tstart}{: Start time of simulation : numeric}

\item{tfinal}{: Final time of simulation : numeric}

\item{dt}{: Times for which result is returned : numeric}

\item{samples}{: Number of values to run between pmin and pmax : numeric}

\item{parmin}{: Lower value for varied parameter : numeric}

\item{parmax}{: Upper value for varied parameter : numeric}

\item{samplepar}{: Name of parameter to be varied : character}

\item{pardist}{: spacing of parameter values, can be either 'lin' or 'log' : character}
}
\value{
The function returns the output as a list,
list element 'dat' contains the data frame with results of interest.
The first column is called xvals and contains the values of the
parameter that has been varied as specified by 'samplepar'.
The remaining columns contain maximum and final state numbers of susceptible, infected and recovered
Smax, Imax, Rmax and Sfinal, Ifinal, Rfinal.
A final boolean variable 'steady' is returned for each simulation.
It is TRUE if the simulation reached steady state, otherwise FALSE.
}
\description{
This function simulates the SIR model ODE for a range of parameters.
The function returns a data frame containing the parameter that has been varied and the outcomes (see details).
}
\details{
This code illustrates how to systematically analyze the impact of a specific parameter.
The SIR ODE model with births and deaths is simulated for different parameter values.
The user can specify which parameter is sampled, and
the simulation returns for each parameter sample the max and final value for the variables.
Also returned is the varied parameter and an indicator if steady state was reached.
}
\section{Notes}{
 The parameter dt only determines for which times the solution is returned,
it is not the internal time step. The latter is set automatically by the ODE solver.
}

\section{Warning}{
 This function does not perform any error checking. So if
  you try to do something nonsensical (e.g. specify negative parameter values
  or fractions > 1), the code will likely abort with an error message.
}

\examples{
# To run the simulation with default parameters just call the function:
\dontrun{res <- simulate_modelexploration_sir()}
# To choose parameter values other than the standard one, specify them, like such:
res <- simulate_modelexploration_sir(tfinal=100, samples=5, samplepar='g', parmin=0.1, parmax=1)
# You should then use the simulation result returned from the function, like this:
plot(res$dat[,"xvals"],res$data[,"Imax"],xlab='Parameter values',ylab='Max Infected',type='l')
}
\seealso{
See the shiny app documentation corresponding to this simulator
function for more details on this model.
}
\author{
Andreas Handel
}
