% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_flu_fit.R
\name{simulate_flu_fit}
\alias{simulate_flu_fit}
\title{Fitting a SIR-type model to flu data}
\usage{
simulate_flu_fit(
  S = 5e+06,
  I = 1,
  D = 0,
  b = 1e-06,
  blow = 1e-08,
  bhigh = 1e-04,
  g = 1,
  glow = 0.01,
  ghigh = 100,
  f = 0.01,
  flow = 1e-04,
  fhigh = 1,
  usesimdata = 0,
  bsim = 1e-06,
  gsim = 1,
  fsim = 0.01,
  noise = 0,
  iter = 1,
  solvertype = 1,
  logfit = 0,
  rngseed = 100
)
}
\arguments{
\item{S}{: starting value for Susceptible : numeric}

\item{I}{: starting value for Infected : numeric}

\item{D}{: starting value for Dead : numeric}

\item{b}{: infection rate : numeric}

\item{blow}{: lower bound for infection rate : numeric}

\item{bhigh}{: upper bound for infection rate : numeric}

\item{g}{: recovery rate : numeric}

\item{glow}{: lower bound for g : numeric}

\item{ghigh}{: upper bound for g : numeric}

\item{f}{: fraction dying : numeric}

\item{flow}{: lower bound for f : numeric}

\item{fhigh}{: upper bound for f : numeric}

\item{usesimdata}{: set to 1 if simulated data should be fitted, 0 otherwise : numeric}

\item{bsim}{: infection rate for simulated data : numeric}

\item{gsim}{: recovery rate for simulated data : numeric}

\item{fsim}{: fraction dying for simulated data : numeric}

\item{noise}{: noise to be added to simulated data : numeric}

\item{iter}{: max number of steps to be taken by optimizer : numeric}

\item{solvertype}{: the type of solver/optimizer to use (1-3) : numeric}

\item{logfit}{: set to 1 if the log of the data should be fitted, 0 otherwise : numeric}

\item{rngseed}{: random number seed for reproducibility : numeric}
}
\value{
The function returns a list containing as elements the best fit time series data frame, the best fit parameters,
the data and the final SSR
}
\description{
Fitting fitting mortality data from the 1918 influenza pandemic
to an SIR-type model to estimate R0. For the data, see 'flu1918data'.
}
\details{
A simple compartmental ODE model is fitted to data.
The model includes susceptible, infected, and dead compartments.
The two processes that are modeled are infection and recovery. A fraction of recovered can die.
Data can either be real or created by running the model with known parameters and using the simulated data to
determine if the model parameters can be identified.
The fitting is done using solvers/optimizers from the nloptr package (which is a wrapper for the nlopt library).
The package provides access to a large number of solvers.
Here, we only implement 3 solvers, namely 1 = NLOPT_LN_COBYLA, 2 = NLOPT_LN_NELDERMEAD, 3 = NLOPT_LN_SBPLX
For details on what those optimizers are and how they work, see the nlopt/nloptr documentation.
}
\section{Warning}{
 This function does not perform any error checking. So if
  you try to do something nonsensical (e.g. specify negative parameter or starting values,
  the code will likely abort with an error message.
}

\examples{
# To run the code with default parameters just call the function:
\dontrun{result <- simulate_flu_fit()}
# To apply different settings, provide them to the simulator function, like such:
result <- simulate_flu_fit(iter = 5, logfit = 1, solvertype = 2, usesimdata = 1)
}
\seealso{
See the Shiny app documentation corresponding to this
function for more details on this model.
}
\author{
Andreas Handel
}
