% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_basicbacteria.R
\name{simulate_basicbacteria}
\alias{simulate_basicbacteria}
\title{Simulation of a basic model with bacteria and an immune response
illustrating a simple within-host predator-prey model}
\usage{
simulate_basicbacteria(B0 = 10, I0 = 1, tmax = 30, g = 1,
  Bmax = 1e+06, dB = 0.1, k = 1e-07, r = 0.001, dI = 1)
}
\arguments{
\item{B0}{initial number of bacteria}

\item{I0}{initial number/strength of immune response}

\item{tmax}{maximum simulation time, units depend on choice of units for your
parameters}

\item{g}{rate of bacteria growth}

\item{Bmax}{carrying capacity for bacteria}

\item{dB}{death rate of bacteria}

\item{k}{rate at which bacteria are killed by immune response}

\item{r}{rate at which immune response is induced by bacteria}

\item{dI}{death rate of immune response}
}
\value{
A list. The list has only one element, called ts.
ts contains the time-series of the simulation.
The 1st column of ts is Time, the other 2 are the
bacteria and immune response. variables Those are labeled Bc and Ic
to indicate a continuous model.
}
\description{
This function runs a simulation of a dynamical model
describing a simple bacteria and immune response system.
The model is implemented as a set of 2 ordinary differential equations.
The user provides initial conditions and parameter values for the system.
The function simulates the ODE using an ODE solver from the deSolve package.
The function returns a list,
the list entry called ts contains time-series of each variable and time.
}
\details{
A simple 2 compartment model is simulated as a set of ordinary differential
equations, using an ode solver from the deSolve package.
}
\section{Warning}{
 This function does not perform any error checking. So if
  you try to do something nonsensical (e.g. specify negative parameter values
  or fractions > 1), the code will likely abort with an error message.
}

\examples{
# To run the simulation with default parameters just call the function:
result <- simulate_basicbacteria()
# To choose parameter values other than the standard one, specify them like such:
result <- simulate_basicbacteria(B0 = 100, I0 = 10, tmax = 100, g = 10)
# You should then use the simulation result returned from the function, like this:
plot(result$ts[,'Time'],result$ts[,'Bc'])
}
\seealso{
See the Shiny app documentation corresponding to this simulator
function for more details on this model. See the manual for the deSolve
package for details on the underlying ODE simulator algorithm.
}
\author{
Andreas Handel
}
