% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_basicvirus_fit.R
\name{simulate_basicvirus_fit}
\alias{simulate_basicvirus_fit}
\title{Fitting a simple viral infection models to influenza data}
\usage{
simulate_basicvirus_fit(
  U = 1e+06,
  I = 0,
  V = 1,
  n = 0,
  dU = 0,
  dI = 2,
  g = 0,
  p = 0.001,
  plow = 1e-04,
  phigh = 100,
  psim = 10,
  b = 0.1,
  blow = 0.001,
  bhigh = 10,
  bsim = 1e-04,
  dV = 1,
  dVlow = 0.01,
  dVhigh = 100,
  dVsim = 5,
  noise = 0,
  iter = 1,
  solvertype = 1,
  usesimdata = 0
)
}
\arguments{
\item{U}{: initial number of uninfected target cells : numeric}

\item{I}{: initial number of infected target cells : numeric}

\item{V}{: initial number of infectious virions : numeric}

\item{n}{: rate of uninfected cell production : numeric}

\item{dU}{: rate at which uninfected cells die : numeric}

\item{dI}{: rate at which infected cells die : numeric}

\item{g}{: unit conversion factor : numeric}

\item{p}{: rate at which infected cells produce virus : numeric}

\item{plow}{: lower bound for p : numeric}

\item{phigh}{: upper bound for p : numeric}

\item{psim}{: rate at which infected cells produce virus for simulated data : numeric}

\item{b}{: rate at which virus infects cells : numeric}

\item{blow}{: lower bound for infection rate : numeric}

\item{bhigh}{: upper bound for infection rate : numeric}

\item{bsim}{: rate at which virus infects cells for simulated data : numeric}

\item{dV}{: rate at which infectious virus is cleared : numeric}

\item{dVlow}{: lower bound for virus clearance rate : numeric}

\item{dVhigh}{: upper bound for virus clearance rate : numeric}

\item{dVsim}{: rate at which infectious virus is cleared for simulated data : numeric}

\item{noise}{: noise to be added to simulated data : numeric}

\item{iter}{: max number of steps to be taken by optimizer : numeric}

\item{solvertype}{: the type of solver/optimizer to use (1-3) : numeric}

\item{usesimdata}{: set to 1 if simulated data should be fitted, 0 otherwise : numeric}
}
\value{
The function returns a list containing as elements the best fit time series data frame, the best fit parameters,
the data and the final SSR
}
\description{
This function runs a simulation of a compartment model
using a set of ordinary differential equations.
The model describes a simple viral infection system.
}
\details{
A simple compartmental ODE model mimicking acute viral infection
is fitted to data.
Data can either be real or created by running the model with known parameters and using the simulated data to
determine if the model parameters can be identified.
The fitting is done using solvers/optimizers from the nloptr package (which is a wrapper for the nlopt library).
The package provides access to a large number of solvers.
Here, we only implement 3 solvers, namely 1 = NLOPT_LN_COBYLA, 2 = NLOPT_LN_NELDERMEAD, 3 = NLOPT_LN_SBPLX
For details on what those optimizers are and how they work, see the nlopt/nloptr documentation.
}
\section{Warning}{
 This function does not perform any error checking. So if
  you try to do something nonsensical (e.g. specify negative parameter or starting values,
  the code will likely abort with an error message.
}

\examples{
# To run the code with default parameters just call the function:
\dontrun{result <- simulate_basicvirus_fit()}
# To apply different settings, provide them to the simulator function, like such:
result <- simulate_basicvirus_fit(iter = 5)
}
\seealso{
See the Shiny app documentation corresponding to this
function for more details on this model.
}
\author{
Andreas Handel
}
