% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSConnection.R
\name{dsAssignResource}
\alias{dsAssignResource}
\title{Assign a resource object}
\usage{
dsAssignResource(conn, symbol, resource, async = TRUE)
}
\arguments{
\item{conn}{An object that inherits from \code{\link{DSConnection-class}}.}

\item{symbol}{Name of the R symbol.}

\item{resource}{Fully qualified name of a resource reference in the data repository.}

\item{async}{Whether the result of the call should be retrieved asynchronously. When TRUE (default) the calls are parallelized over
the connections, when the connection supports that feature, with an extra overhead of requests.}
}
\description{
Assign a resource object of class 'ResourceClient' from the data repository to a symbol in the DataSHIELD R session.
The resource reference to be assigned must exist (i.e. proper permissions apply) for the DataSHIELD user.

\Sexpr[results=rd,stage=render]{DSI:::methods_as_rd("dsAssignResource")}
}
\examples{
\dontrun{
con <- dsConnect(DSOpal::Opal(), "server1",
  username = "dsuser", password = "password", url = "https://opal-demo.obiba.org")
dsAssignResource(con, "D", "test.CNSIM")
dsDisconnect(con)
}
}
\seealso{
Other DSConnection generics: 
\code{\link{DSConnection-class}},
\code{\link{dsAggregate}()},
\code{\link{dsAssignExpr}()},
\code{\link{dsAssignTable}()},
\code{\link{dsDisconnect}()},
\code{\link{dsGetInfo}()},
\code{\link{dsHasResource}()},
\code{\link{dsHasTable}()},
\code{\link{dsIsAsync}()},
\code{\link{dsKeepAlive}()},
\code{\link{dsListMethods}()},
\code{\link{dsListPackages}()},
\code{\link{dsListProfiles}()},
\code{\link{dsListResources}()},
\code{\link{dsListSymbols}()},
\code{\link{dsListTables}()},
\code{\link{dsListWorkspaces}()},
\code{\link{dsRmSymbol}()},
\code{\link{dsRmWorkspace}()},
\code{\link{dsSaveWorkspace}()}
}
\concept{DSConnection generics}
