% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.dsspMod}
\alias{summary.dsspMod}
\title{Summarise a \code{dsspMod} model}
\usage{
\method{summary}{dsspMod}(object, prob = 0.95, robust = FALSE, mc_se = FALSE, ...)
}
\arguments{
\item{object}{an object of class \code{dsspMod}}

\item{prob}{the desired probability to be covered by the credible intervals.
The default is 0.95.}

\item{robust}{whether or not to use the median (rather than the mean) to
calculate the estimates that summarise the posterior.
Default to \code{FALSE}.}

\item{mc_se}{whether or not to include the uncertainty in \code{Estimate}
caused by sampling should be shown in the summary. Defaults to \code{FALSE}.}

\item{...}{additional arguments which are ignored.}
}
\value{
An object of class "dsspModsummary". Provides a summary of the the Direct Sampling Spatial Prior (DSSP) model. Includes details of the formula used to fit the model, and a summary of the model (\eqn{eta, delta}) and the covariates.
}
\description{
Summarise a \code{dsspMod} model
}
\examples{
library(sp)
library(gstat)
data(meuse.all)
coordinates(meuse.all) <- ~ x + y

f <- function(x) -x ## log-prior for exponential distribution for the smoothing parameter

## Draw 100 samples from the posterior of eta given the data y.
OUTPUT <- DSSP(
  formula = log(zinc) ~ 1, data = meuse.all, N = 100,
  pars = c(0.001, 0.001), log_prior = f
)
summary(OUTPUT)
}
