% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataOutput.R
\name{dataOutput}
\alias{dataOutput}
\alias{dataOutputUI}
\alias{dataOutputServer}
\title{Shiny module for data output}
\usage{
dataOutputUI(id, icon = "download")

dataOutputServer(
  id,
  data = reactive(NULL),
  save_as = NULL,
  write_fun = "write.csv",
  write_args = NULL,
  hide = FALSE
)
}
\arguments{
\item{id}{unique identifier for the module to prevent namespace clashes when
making multiple calls to this shiny module.}

\item{icon}{supplied to \code{dataOutputUI} to control the appearance of the
icon displayed on the download button, set to \code{"download"} by default.}

\item{data}{an object of class data.frame wrapped in \code{reactive} to be
saved to file.}

\item{save_as}{name of the file to which the data should be saved, overrides
input file path if supplied.}

\item{write_fun}{name of the function to use when writing the data to file,
set to \code{"write.csv"} by default.}

\item{write_args}{a named list of additional arguments to pass to
\code{write_fun} when reading in files.}

\item{hide}{logical indicating whether the data input user interface should
be hidden from the user, set to FALSE by default.}
}
\description{
Shiny module for data output
}
\examples{
if (interactive()) {
  library(shiny)
  library(rhandsontable)
  library(shinyjs)

  ui <- fluidPage(
    useShinyjs(),
    dataInputUI("input1"),
    dataOutputUI("output1"),
    rHandsontableOutput("data1")
  )

  server <- function(input,
                     output,
                     session) {
    data_input1 <- dataInputServer("input1")

    output$data1 <- renderRHandsontable({
      if (!is.null(data_input1())) {
        rhandsontable(data_input1())
      }
    })

    dataOutputServer("output1",
      data = data_input1
    )
  }

  shinyApp(ui, server)
}
}
\author{
Dillon Hammill, \email{Dillon.Hammill@anu.edu.au}
}
