% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CollapseCategory.r
\name{CollapseCategory}
\alias{CollapseCategory}
\title{Collapse categories for discrete features}
\usage{
CollapseCategory(data, feature, threshold, update = FALSE)
}
\arguments{
\item{data}{input data, in either \link{data.frame} or \link{data.table} format.}

\item{feature}{name of the discrete feature to be collapsed.}

\item{threshold}{the bottom x\% categories to be collapsed, e.g., if set to 20\%, categories with cumulative frequency of the bottom 20\% will be collapsed.}

\item{update}{logical, indicating if the data should be modified. Setting to \code{TRUE} will modify the input data without returning anything. The default is \code{FALSE}.}
}
\value{
if update is set to \code{FALSE}, returns a \link{data.table} object containing categories with cumulative frequency less than the input threshold.
}
\description{
Sometimes discrete features have sparse categories. This function will collapse the sparse categories for a discrete feature based on a given threshold.
}
\details{
If a continuous feature is passed to the argument \code{feature}, it will be force set to \link{character-class}.
}
\examples{
# load packages
library(data.table)

# generate data
data <- data.table("a" = as.factor(round(rnorm(500, 10, 5))))

# view cumulative frequency without collpasing categories
CollapseCategory(data, "a", 0.2)

# collapse bottom 20\\\% categories based on cumulative frequency
CollapseCategory(data, "a", 0.2, update = TRUE)
BarDiscrete(data)
}
\keyword{collapsecategory}

