% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_density.r
\name{plot_density}
\alias{plot_density}
\title{Plot density estimates}
\usage{
plot_density(
  data,
  binary_as_factor = TRUE,
  geom_density_args = list(),
  scale_x = "continuous",
  title = NULL,
  ggtheme = theme_gray(),
  theme_config = list(),
  nrow = 4L,
  ncol = 4L,
  parallel = FALSE
)
}
\arguments{
\item{data}{input data}

\item{binary_as_factor}{treat binary as categorical? Default is \code{TRUE}.}

\item{geom_density_args}{a list of other arguments to \link{geom_density}}

\item{scale_x}{scale of x axis. See \link{scale_x_continuous} for all options. Default is \code{continuous}.}

\item{title}{plot title}

\item{ggtheme}{complete ggplot2 themes. The default is \link{theme_gray}.}

\item{theme_config}{a list of configurations to be passed to \link{theme}.}

\item{nrow}{number of rows per page. Default is 4.}

\item{ncol}{number of columns per page. Default is 4.}

\item{parallel}{enable parallel? Default is \code{FALSE}.}
}
\value{
invisibly return the named list of ggplot objects
}
\description{
Plot density estimates for each continuous feature
}
\examples{
# Plot iris data
plot_density(iris, ncol = 2L)

# Add color to density area
plot_density(iris, geom_density_args = list("fill" = "black", "alpha" = 0.6), ncol = 2L)

# Plot skewed data on log scale
set.seed(1)
skew <- data.frame(replicate(4L, rbeta(1000, 1, 5000)))
plot_density(skew, ncol = 2L)
plot_density(skew, scale_x = "log10", ncol = 2L)
}
\seealso{
\link{geom_density} \link{plot_histogram}
}
\keyword{plot_density}
