% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI.R
\name{dbClearResult,DatabaseConnectorResult-method}
\alias{dbClearResult,DatabaseConnectorResult-method}
\title{Clear a result set}
\usage{
\S4method{dbClearResult}{DatabaseConnectorResult}(res, ...)
}
\arguments{
\item{res}{An object inheriting from \linkS4class{DBIResult}.}

\item{...}{Other arguments passed on to methods.}
}
\value{
\code{dbClearResult()} returns \code{TRUE}, invisibly, for result sets obtained from
both \code{dbSendQuery()}
and \code{dbSendStatement()}.
An attempt to close an already closed result set issues a warning
in both cases.
}
\description{
Frees all resources (local and remote) associated with a result set.  In some
cases (e.g., very large result sets) this can be a critical step to avoid
exhausting resources (memory, file descriptors, etc.)

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("dbClearResult")}
}
\seealso{
Other DBIResult generics: 
\code{\link[DBI]{DBIResult-class}},
\code{\link[DBI]{dbBind}()},
\code{\link[DBI]{dbColumnInfo}()},
\code{\link[DBI]{dbFetch}()},
\code{\link[DBI]{dbGetInfo}()},
\code{\link[DBI]{dbGetRowCount}()},
\code{\link[DBI]{dbGetRowsAffected}()},
\code{\link[DBI]{dbGetStatement}()},
\code{\link[DBI]{dbHasCompleted}()},
\code{\link[DBI]{dbIsReadOnly}()},
\code{\link[DBI]{dbIsValid}()},
\code{\link[DBI]{dbQuoteIdentifier}()},
\code{\link[DBI]{dbQuoteLiteral}()},
\code{\link[DBI]{dbQuoteString}()},
\code{\link[DBI]{dbUnquoteIdentifier}()}
}
