% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI.R
\name{dbFetch,DatabaseConnectorResult-method}
\alias{dbFetch,DatabaseConnectorResult-method}
\title{Fetch records from a previously executed query}
\usage{
\S4method{dbFetch}{DatabaseConnectorResult}(res, n = -1, ...)
}
\arguments{
\item{res}{An object inheriting from \linkS4class{DBIResult}, created by
\code{\link[DBI:dbSendQuery]{dbSendQuery()}}.}

\item{n}{maximum number of records to retrieve per fetch. Use \code{n = -1}
or \code{n = Inf}
to retrieve all pending records.  Some implementations may recognize other
special values.}

\item{...}{Other arguments passed on to methods.}
}
\value{
\code{dbFetch()} always returns a \link{data.frame}
with as many rows as records were fetched and as many
columns as fields in the result set,
even if the result is a single value
or has one
or zero rows.
An attempt to fetch from a closed result set raises an error.
If the \code{n} argument is not an atomic whole number
greater or equal to -1 or Inf, an error is raised,
but a subsequent call to \code{dbFetch()} with proper \code{n} argument succeeds.
Calling \code{dbFetch()} on a result set from a data manipulation query
created by \code{\link[DBI:dbSendStatement]{dbSendStatement()}}
can be fetched and return an empty data frame, with a warning.
}
\description{
Fetch the next \code{n} elements (rows) from the result set and return them
as a data.frame.

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("dbFetch")}
}
\details{
\code{fetch()} is provided for compatibility with older DBI clients - for all
new code you are strongly encouraged to use \code{dbFetch()}. The default
implementation for \code{dbFetch()} calls \code{fetch()} so that it is compatible with
existing code. Modern backends should implement for \code{dbFetch()} only.
}
\seealso{
Close the result set with \code{\link[DBI:dbClearResult]{dbClearResult()}} as soon as you
finish retrieving the records you want.

Other DBIResult generics: 
\code{\link[DBI]{DBIResult-class}},
\code{\link[DBI]{dbBind}()},
\code{\link[DBI]{dbClearResult}()},
\code{\link[DBI]{dbColumnInfo}()},
\code{\link[DBI]{dbGetInfo}()},
\code{\link[DBI]{dbGetRowCount}()},
\code{\link[DBI]{dbGetRowsAffected}()},
\code{\link[DBI]{dbGetStatement}()},
\code{\link[DBI]{dbHasCompleted}()},
\code{\link[DBI]{dbIsReadOnly}()},
\code{\link[DBI]{dbIsValid}()},
\code{\link[DBI]{dbQuoteIdentifier}()},
\code{\link[DBI]{dbQuoteLiteral}()},
\code{\link[DBI]{dbQuoteString}()},
\code{\link[DBI]{dbUnquoteIdentifier}()}
}
