/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.databaseConnector;

import java.util.ArrayList;
import java.util.List;
import org.ohdsi.databaseConnector.RFunctionToTranslate;

public class RtoSqlTranslator {
    private String string;

    public RtoSqlTranslator(String string) {
        this.string = string.replaceAll("DatabaseConnector::", "");
    }

    public String getSql() {
        return this.string;
    }

    public void translate(RFunctionToTranslate rFunctionToTranslate) {
        int searchStart = 0;
        while (searchStart < this.string.length()) {
            int cursor = 0;
            int wordStart = -1;
            int argumentStart = -1;
            int parenthesisLevel = 0;
            boolean functionNameFound = false;
            boolean singleQuote = false;
            boolean doubleQuote = false;
            ArrayList<ArgumentInstance> argumentInstances = new ArrayList<ArgumentInstance>();
            while (cursor < this.string.length()) {
                char ch = this.string.charAt(cursor);
                if (!singleQuote && !doubleQuote) {
                    if (!functionNameFound) {
                        if (Character.isLetter(ch) && wordStart == -1) {
                            wordStart = cursor;
                        }
                        if (!Character.isLetter(ch) && wordStart != -1 && cursor < this.string.length() - 1) {
                            String word;
                            if (ch == '(' && (word = this.string.substring(wordStart, cursor)).toLowerCase().equals(rFunctionToTranslate.getName().toLowerCase())) {
                                searchStart = cursor;
                                functionNameFound = true;
                                this.string = String.valueOf(this.string.substring(0, wordStart)) + word.toUpperCase() + this.string.substring(cursor);
                                argumentStart = cursor + 1;
                            }
                            wordStart = -1;
                        }
                    } else if (ch == '(') {
                        ++parenthesisLevel;
                    } else if (ch == ')' && parenthesisLevel > 0) {
                        --parenthesisLevel;
                    } else if (parenthesisLevel == 0 && (ch == ',' || ch == ')')) {
                        ArgumentInstance argumentInstance = new ArgumentInstance();
                        argumentInstance.start = argumentStart;
                        argumentInstance.end = cursor;
                        argumentInstances.add(argumentInstance);
                        argumentStart = cursor + 1;
                        if (ch == ')') {
                            this.translateArguments(argumentInstances, rFunctionToTranslate);
                            functionNameFound = false;
                            cursor = searchStart;
                            argumentInstances.clear();
                        }
                    }
                }
                if (ch == '\'' && !doubleQuote) {
                    boolean bl = singleQuote = !singleQuote;
                }
                if (ch == '\"' && !singleQuote) {
                    doubleQuote = !doubleQuote;
                }
                ++cursor;
            }
            searchStart = this.string.length();
        }
    }

    private void translateArguments(List<ArgumentInstance> argumentInstances, RFunctionToTranslate rFunctionToTranslate) {
        List<RFunctionToTranslate.Argument> arguments = rFunctionToTranslate.getArguments();
        if (argumentInstances.size() != arguments.size()) {
            throw new RuntimeException("Must provide all arguments for function " + rFunctionToTranslate.getName() + " to translate properly");
        }
        int blockStart = 999999;
        int blockEnd = -1;
        int[] outputIndices = new int[argumentInstances.size()];
        int j = 0;
        while (j < argumentInstances.size()) {
            ArgumentInstance argumentInstance = argumentInstances.get(j);
            if (argumentInstance.start < blockStart) {
                blockStart = argumentInstance.start;
            }
            if (argumentInstance.end > blockEnd) {
                blockEnd = argumentInstance.end;
            }
            String text = this.string.substring(argumentInstance.start, argumentInstance.end).trim();
            int outputIndex = j;
            int i = 0;
            while (i < arguments.size()) {
                if (text.endsWith(" AS " + arguments.get((int)i).name)) {
                    outputIndex = i;
                    text = text.substring(0, text.length() - arguments.get((int)i).name.length() - 4);
                    break;
                }
                ++i;
            }
            if (arguments.get((int)outputIndex).removeQuotes && text.length() > 2 && text.charAt(0) == '\'' && text.charAt(text.length() - 1) == '\'') {
                text = text.substring(1, text.length() - 1);
            }
            outputIndices[outputIndex] = j++;
            argumentInstance.text = text;
        }
        String outputString = "";
        int i = 0;
        while (i < outputIndices.length) {
            if (i != 0) {
                outputString = String.valueOf(outputString) + ", ";
            }
            outputString = String.valueOf(outputString) + argumentInstances.get((int)outputIndices[i]).text;
            ++i;
        }
        this.string = String.valueOf(this.string.substring(0, blockStart)) + outputString + this.string.substring(blockEnd);
    }

    private class ArgumentInstance {
        public int start;
        public int end;
        public String text;

        private ArgumentInstance() {
        }
    }
}

