/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.Column;
import com.microsoft.sqlserver.jdbc.SQLIdentifier;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SSType;
import com.microsoft.sqlserver.jdbc.StreamColInfo;
import com.microsoft.sqlserver.jdbc.StreamPacket;
import com.microsoft.sqlserver.jdbc.StreamTabName;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TypeInfo;

final class StreamColumns
extends StreamPacket {
    private Column[] columns;

    StreamColumns() {
        super(129);
    }

    @Override
    void setFromTDS(TDSReader tDSReader) throws SQLServerException {
        if (129 != tDSReader.readUnsignedByte()) assert (false);
        int n = tDSReader.readUnsignedShort();
        if (65535 == n) {
            return;
        }
        this.columns = new Column[n];
        for (int i = 0; i < n; ++i) {
            TypeInfo typeInfo = TypeInfo.getInstance(tDSReader);
            SQLIdentifier sQLIdentifier = new SQLIdentifier();
            if (SSType.TEXT == typeInfo.getSSType() || SSType.NTEXT == typeInfo.getSSType() || SSType.IMAGE == typeInfo.getSSType()) {
                sQLIdentifier = tDSReader.readSQLIdentifier();
            }
            String string = tDSReader.readUnicodeString(tDSReader.readUnsignedByte());
            this.columns[i] = new Column(typeInfo, string, sQLIdentifier);
        }
    }

    Column[] buildColumns(StreamColInfo streamColInfo, StreamTabName streamTabName) throws SQLServerException {
        if (null != streamColInfo && null != streamTabName) {
            streamTabName.applyTo(this.columns, streamColInfo.applyTo(this.columns));
        }
        return this.columns;
    }
}

