% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_hist.R
\name{plot_hist}
\alias{plot_hist}
\title{Group and/or log-scale histogram}
\usage{
plot_hist(
  x,
  breaks = 100,
  id = NA,
  select = NA,
  pile = TRUE,
  line = FALSE,
  mids = FALSE,
  xlim = NA,
  ylim = NA,
  xlog = FALSE,
  axes = TRUE,
  xa = list(),
  ya = list(),
  main = "",
  xlab = "X",
  ylab = "Counts",
  col = NA,
  border = NA,
  text = FALSE,
  labels = NA,
  t = list(adj = c(0.5, -2), font = 2),
  add = FALSE
)
}
\arguments{
\item{x}{vector or matrix}

\item{breaks}{one of:
\itemize{
\item{a vector giving the breakpoints between histogram cells,}
\item{a function to compute the vector of breakpoints,}
\item{a single number giving the number of cells for the histogram,}
\item{a character string naming an algorithm to compute the number of cells
(see ‘Details’ in \code{\link{hist}}),}
\item{a function to compute the number of cells.}
}
In the last three cases the number is a suggestion only; as the breakpoints
will be set to pretty values, the number is limited to 1e6 (with a warning if
it was larger). If breaks is a function, the x vector is supplied to it as
the only argument (and the number of breaks is only limited by the amount of
available memory).}

\item{id}{a vector of ids for each x value, to separate different groups of
data}

\item{select}{a vector of id values idenifying the groups of data to plot and
their order}

\item{pile}{whether to cumulate the different one on the other}

\item{line}{whether to plot as lines or rectangles}

\item{mids}{if lines is TRUE, whether the nodes of the lines are the middle
positions or the upper corner of the rectangles.}

\item{xlim, ylim}{the boundaries for the plots. If ylim = NA the upper ylim
will be increased by 10\% to allow for text (see 'text' parameter)}

\item{xlog}{whether to set the x axis in log scale}

\item{axes}{whether to plot the axes}

\item{xa, ya}{list of arguments to feed minorAxis for the x and y axes
respectively}

\item{main, xlab, ylab}{the main title and the labels of the x and y axes}

\item{col}{a function or a character vector defining the colors of the
different modes}

\item{border}{the colour of the borders, by default identical to col}

\item{text}{if there are different groups, whether to add a number above
each of them to distinguish them}

\item{labels}{the labels to put on top of each group}

\item{t}{a list of parameters to feed text()}

\item{add}{whether to add the plot to a preexisting plot}
}
\description{
Specialised histogram: allows to work in log-scale (for x) and
to distinguish different groups of data
}
\examples{
set.seed(42)

n <- 600
t <- seq_len(n)

p1 <- 30
p2 <- 240

xy <- (1 + 0.6 * sin(t*2*pi/p2)) * sin(t*2*pi/p1)  + 2 * sin(t*2*pi/p2) +
  rnorm(n, sd = 0.5) + t * 0.01

inter_dt <- round(runif(length(xy), min = 0.5, max = 1.5),1)

dt <- cumsum(inter_dt)

dec <- extricate(xy, dt, nimf = 7, repl = 10, comb = 10, factor_noise = 10,
                 speak = TRUE)

\donttest{
plot_emd(dec, dir = tempdir())}

integrity(xy, dec)
parsimony(dec)

ht  <- inst.pulse(dec, plot = FALSE)

opar <- par('mfrow')

par(mfrow = c(2,1))

plot_hist(x = 1/ht$f, breaks = 500,
          xlog = TRUE, xlab = "Period")

plot_hist(x = 1/ht$f, breaks = 500, id = ht$mode,
          xlog = TRUE, text = TRUE, add = TRUE, line = TRUE, pile = FALSE)

abline(v = c(p1, p2), col = "red", lwd = 2, lty = 5)

plot_hist(x = 1/ht$f, breaks = 500, id = ht$mode,
          xlog = TRUE, text = TRUE, xlab = "Period")

abline(v = c(p1, p2), col = "red", lwd = 2, lty = 5)

par(mfrow = opar)

}
