/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.plots;

import java.awt.Color;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.rosuda.deducer.plots.Aes;
import org.rosuda.deducer.plots.ParamFactory;
import org.rosuda.deducer.plots.ParamStatSummary;
import org.rosuda.deducer.toolkit.XMLHelper;
import org.rosuda.deducer.widgets.param.Param;
import org.rosuda.deducer.widgets.param.ParamCharacter;
import org.rosuda.deducer.widgets.param.ParamLogical;
import org.rosuda.deducer.widgets.param.ParamNumeric;
import org.rosuda.deducer.widgets.param.ParamVector;
import org.rosuda.deducer.widgets.param.RFunction;
import org.rosuda.deducer.widgets.param.RFunctionList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Stat {
    public String name;
    public Vector aess = new Vector();
    public Vector params = new Vector();
    public String defaultGeom;
    public Vector generated = new Vector();

    public Object clone() {
        Object object;
        int n;
        Stat stat = new Stat();
        stat.name = this.name;
        stat.defaultGeom = this.defaultGeom;
        for (n = 0; n < this.aess.size(); ++n) {
            object = (Aes)this.aess.get(n);
            stat.aess.add(((Aes)object).clone());
        }
        for (n = 0; n < this.params.size(); ++n) {
            object = (Param)this.params.get(n);
            stat.params.add(((Param)object).clone());
        }
        for (n = 0; n < this.generated.size(); ++n) {
            stat.generated.add(this.generated.get(n));
        }
        return stat;
    }

    public static Stat makeIdentity() {
        Stat stat = new Stat();
        stat.name = "identity";
        stat.defaultGeom = "point";
        return stat;
    }

    public static Stat makeCount() {
        Stat stat = new Stat();
        stat.name = "bar";
        stat.defaultGeom = "bar";
        Aes aes = Aes.makeAes("x");
        aes.required = true;
        stat.aess.add(aes);
        aes = Aes.makeAes("y");
        aes.defaultVariable = "..count..";
        aes.variable = "..count..";
        stat.aess.add(aes);
        Param param = ParamFactory.makeParam("binwidth");
        stat.params.add(param);
        param = ParamFactory.makeParam("origin");
        stat.params.add(param);
        param = ParamFactory.makeParam("breaks");
        stat.params.add(param);
        param = ParamFactory.makeParam("width");
        stat.params.add(param);
        param = ParamFactory.makeParam("drop");
        stat.params.add(param);
        stat.generated.add("count");
        return stat;
    }

    public static Stat makeBin() {
        Stat stat = new Stat();
        stat.name = "bin";
        stat.defaultGeom = "bar";
        Aes aes = Aes.makeAes("x");
        aes.required = true;
        stat.aess.add(aes);
        aes = Aes.makeAes("y");
        aes.defaultVariable = "..count..";
        aes.variable = "..count..";
        stat.aess.add(aes);
        Param param = ParamFactory.makeParam("binwidth");
        stat.params.add(param);
        param = ParamFactory.makeParam("origin");
        stat.params.add(param);
        param = ParamFactory.makeParam("breaks");
        stat.params.add(param);
        param = ParamFactory.makeParam("width");
        stat.params.add(param);
        param = ParamFactory.makeParam("drop");
        stat.params.add(param);
        stat.generated.add("count");
        stat.generated.add("density");
        stat.generated.add("ncount");
        stat.generated.add("ndensity");
        return stat;
    }

    public static Stat makeBin2d() {
        Stat stat = new Stat();
        stat.name = "bin_2d";
        stat.defaultGeom = "rect";
        Aes aes = Aes.makeAes("x");
        aes.required = true;
        stat.aess.add(aes);
        aes = Aes.makeAes("y");
        aes.required = true;
        stat.aess.add(aes);
        aes = Aes.makeAes("fill");
        aes.defaultVariable = "..count..";
        aes.variable = "..count..";
        stat.aess.add(aes);
        ParamVector paramVector = new ParamVector("binwidth");
        paramVector.setViewType("org.rosuda.deducer.widgets.param.ParamTwoValueWidget");
        stat.params.add(paramVector);
        paramVector = new ParamVector("origin");
        paramVector.setViewType("org.rosuda.deducer.widgets.param.ParamTwoValueWidget");
        stat.params.add(paramVector);
        RFunctionList rFunctionList = new RFunctionList("breaks");
        RFunction rFunction = new RFunction();
        rFunction.setName("list");
        rFunction.add(new ParamVector("x"));
        rFunction.add(new ParamVector("y"));
        rFunctionList.addRFunction("breaks", rFunction);
        stat.params.add(rFunctionList);
        Param param = ParamFactory.makeParam("drop");
        stat.params.add(param);
        stat.generated.add("count");
        stat.generated.add("density");
        stat.generated.add("xint");
        stat.generated.add("xmin");
        stat.generated.add("xmax");
        stat.generated.add("yint");
        stat.generated.add("ymin");
        stat.generated.add("ymax");
        return stat;
    }

    public static Stat makeBinDot() {
        Stat stat = new Stat();
        stat.name = "bindot";
        stat.defaultGeom = "dotplot";
        Aes aes = Aes.makeAes("x");
        aes.required = true;
        stat.aess.add(aes);
        aes = Aes.makeAes("y");
        aes.defaultVariable = "..count..";
        aes.variable = "..count..";
        stat.aess.add(aes);
        ParamCharacter paramCharacter = new ParamCharacter("method");
        paramCharacter.setOptions(new String[]{"dotdensity", "histodot"});
        paramCharacter.setViewType("org.rosuda.deducer.widgets.param.ParamComboBoxWidget");
        paramCharacter.setDefaultValue("dotdensity");
        paramCharacter.setValue("dotdensity");
        stat.params.add(paramCharacter);
        paramCharacter = new ParamCharacter("binpositions");
        paramCharacter.setOptions(new String[]{"bygroup", "all"});
        paramCharacter.setViewType("org.rosuda.deducer.widgets.param.ParamComboBoxWidget");
        paramCharacter.setDefaultValue("bygroup");
        paramCharacter.setValue("bygroup");
        stat.params.add(paramCharacter);
        paramCharacter = new ParamCharacter("binaxis");
        paramCharacter.setOptions(new String[]{"x", "y"});
        paramCharacter.setViewType("org.rosuda.deducer.widgets.param.ParamComboBoxWidget");
        paramCharacter.setDefaultValue("x");
        paramCharacter.setValue("x");
        stat.params.add(paramCharacter);
        Param param = ParamFactory.makeParam("binwidth");
        stat.params.add(param);
        param = ParamFactory.makeParam("origin");
        stat.params.add(param);
        param = ParamFactory.makeParam("breaks");
        stat.params.add(param);
        ParamNumeric paramNumeric = (ParamNumeric)ParamFactory.makeParam("width");
        paramNumeric.setDefaultValue(0.9);
        paramNumeric.setValue(0.9);
        stat.params.add(paramNumeric);
        param = ParamFactory.makeParam("drop");
        param.setDefaultValue(new Boolean(false));
        param.setValue(new Boolean(false));
        stat.params.add(param);
        ParamLogical paramLogical = new ParamLogical("right");
        paramLogical.setDefaultValue(true);
        paramLogical.setValue(true);
        stat.params.add(paramLogical);
        param = ParamFactory.makeParam("na.rm");
        stat.params.add(param);
        stat.generated.add("count");
        return stat;
    }

    public static Stat makeBoxplot() {
        Stat stat = new Stat();
        stat.name = "boxplot";
        stat.defaultGeom = "boxplot";
        Aes aes = Aes.makeAes("x");
        aes.required = true;
        stat.aess.add(aes);
        aes = Aes.makeAes("y");
        aes.required = true;
        stat.aess.add(aes);
        Param param = ParamFactory.makeParam("na.rm");
        stat.params.add(param);
        param = ParamFactory.makeParam("width");
        stat.params.add(param);
        param = ParamFactory.makeParam("coef");
        stat.params.add(param);
        stat.generated.add("width");
        stat.generated.add("ymin");
        stat.generated.add("lower");
        stat.generated.add("middle");
        stat.generated.add("upper");
        stat.generated.add("ymax");
        stat.generated.add("ymin");
        stat.generated.add("ymax");
        return stat;
    }

    public static Stat makeContour() {
        Stat stat = new Stat();
        stat.name = "contour";
        stat.defaultGeom = "path";
        Aes aes = Aes.makeAes("x");
        aes.required = true;
        stat.aess.add(aes);
        aes = Aes.makeAes("y");
        aes.required = true;
        stat.aess.add(aes);
        aes = Aes.makeAes("z");
        aes.required = true;
        stat.aess.add(aes);
        aes = Aes.makeAes("group");
        aes.defaultUseVariable = true;
        aes.defaultVariable = "..piece..";
        stat.aess.add(aes);
        Param param = ParamFactory.makeParam("bins");
        stat.params.add(param);
        param = ParamFactory.makeParam("binwidth");
        stat.params.add(param);
        param = ParamFactory.makeParam("breaks");
        stat.params.add(param);
        param = ParamFactory.makeParam("na.rm");
        stat.params.add(param);
        stat.generated.add("level");
        stat.generated.add("piece");
        return stat;
    }

    public static Stat makeDensity() {
        Stat stat = new Stat();
        stat.name = "density";
        stat.defaultGeom = "area";
        Aes aes = Aes.makeAes("x");
        aes.required = true;
        stat.aess.add(aes);
        aes = Aes.makeAes("y");
        aes.required = true;
        aes.defaultVariable = "..density..";
        aes.variable = "..density..";
        stat.aess.add(aes);
        aes = Aes.makeAes("fill");
        aes.preferCategorical = true;
        stat.aess.add(aes);
        aes = Aes.makeAes("group");
        stat.aess.add(aes);
        Param param = ParamFactory.makeParam("adjust");
        stat.params.add(param);
        param = ParamFactory.makeParam("kernel");
        stat.params.add(param);
        param = ParamFactory.makeParam("trim");
        stat.params.add(param);
        param = ParamFactory.makeParam("na.rm");
        stat.params.add(param);
        stat.generated.add("density");
        stat.generated.add("count");
        stat.generated.add("scaled");
        return stat;
    }

    public static Stat makeDensity2d() {
        Stat stat = new Stat();
        stat.name = "density_2d";
        stat.defaultGeom = "density_2d";
        Aes aes = Aes.makeAes("x");
        aes.required = true;
        stat.aess.add(aes);
        aes = Aes.makeAes("y");
        aes.required = true;
        stat.aess.add(aes);
        aes = Aes.makeAes("colour");
        aes.value = aes.defaultValue = Color.decode("#3366FF");
        aes.preferCategorical = true;
        stat.aess.add(aes);
        aes = Aes.makeAes("group");
        aes.variable = aes.defaultVariable = "interaction(..piece..,..level..)";
        stat.aess.add(aes);
        Param param = ParamFactory.makeParam("na.rm");
        stat.params.add(param);
        param = ParamFactory.makeParam("contour");
        stat.params.add(param);
        stat.generated.add("level");
        stat.generated.add("piece");
        return stat;
    }

    public static Stat makeEcdf() {
        Stat stat = new Stat();
        stat.name = "ecdf";
        stat.defaultGeom = "area";
        Aes aes = Aes.makeAes("x");
        aes.required = true;
        stat.aess.add(aes);
        aes = Aes.makeAes("y");
        aes.required = true;
        aes.defaultVariable = "..y..";
        aes.variable = "..y..";
        stat.aess.add(aes);
        return stat;
    }

    public static Stat makeFunction() {
        Stat stat = new Stat();
        stat.name = "function";
        stat.defaultGeom = "path";
        Aes aes = Aes.makeAes("x");
        aes.required = true;
        stat.aess.add(aes);
        Param param = ParamFactory.makeParam("fun");
        stat.params.add(param);
        param = ParamFactory.makeParam("args");
        stat.params.add(param);
        stat.generated.add("y");
        return stat;
    }

    public static Stat makeBinhex() {
        Stat stat = new Stat();
        stat.name = "bin_hex";
        stat.defaultGeom = "hex";
        Aes aes = Aes.makeAes("x");
        stat.aess.add(aes);
        aes = Aes.makeAes("y");
        stat.aess.add(aes);
        aes = Aes.makeAes("fill");
        aes.variable = aes.defaultVariable = "..count..";
        aes.preferCategorical = true;
        stat.aess.add(aes);
        aes = Aes.makeAes("group");
        stat.aess.add(aes);
        Param param = ParamFactory.makeParam("na.rm");
        stat.params.add(param);
        ParamVector paramVector = new ParamVector("binwidth");
        paramVector.setViewType("org.rosuda.deducer.widgets.param.ParamTwoValueWidget");
        stat.params.add(paramVector);
        param = ParamFactory.makeParam("bins");
        stat.params.add(param);
        stat.generated.add("level");
        stat.generated.add("piece");
        return stat;
    }

    public static Stat makeQq() {
        Stat stat = new Stat();
        stat.name = "qq";
        stat.defaultGeom = "point";
        Aes aes = Aes.makeAes("sample");
        aes.required = true;
        stat.aess.add(aes);
        aes = Aes.makeAes("x", null, "..theoretical..");
        stat.aess.add(aes);
        aes = Aes.makeAes("y", null, "..sample..");
        stat.aess.add(aes);
        Param param = ParamFactory.makeParam("quantiles");
        param.setValue(new String[0]);
        param.setDefaultValue(new String[0]);
        stat.params.add(param);
        param = ParamFactory.makeParam("distribution");
        stat.params.add(param);
        param = ParamFactory.makeParam("na.rm");
        stat.params.add(param);
        stat.generated.add("theoretical");
        stat.generated.add("sample");
        return stat;
    }

    public static Stat makeQuantile() {
        Stat stat = new Stat();
        stat.name = "quantile";
        stat.defaultGeom = "quantile";
        Aes aes = Aes.makeAes("x");
        stat.aess.add(aes);
        aes = Aes.makeAes("y");
        stat.aess.add(aes);
        aes = Aes.makeAes("group", null, "..quantile..");
        stat.aess.add(aes);
        Param param = ParamFactory.makeParam("quantiles");
        stat.params.add(param);
        param = ParamFactory.makeParam("formula");
        stat.params.add(param);
        param = ParamFactory.makeParam("na.rm");
        stat.params.add(param);
        stat.generated.add("quantile");
        return stat;
    }

    public static Stat makeSmooth() {
        Stat stat = new Stat();
        stat.name = "smooth";
        stat.defaultGeom = "smooth";
        Aes aes = Aes.makeAes("x");
        stat.aess.add(aes);
        aes = Aes.makeAes("group");
        stat.aess.add(aes);
        Param param = ParamFactory.makeParam("method");
        stat.params.add(param);
        param = ParamFactory.makeParam("formula");
        stat.params.add(param);
        param = ParamFactory.makeParam("se");
        stat.params.add(param);
        param = ParamFactory.makeParam("fullrange");
        stat.params.add(param);
        param = ParamFactory.makeParam("na.rm");
        stat.params.add(param);
        stat.generated.add("ymin");
        stat.generated.add("ymax");
        stat.generated.add("se");
        return stat;
    }

    public static Stat makeSpoke() {
        Stat stat = new Stat();
        stat.name = "spoke";
        stat.defaultGeom = "segment";
        Aes aes = Aes.makeAes("x");
        stat.aess.add(aes);
        aes = Aes.makeAes("y");
        stat.aess.add(aes);
        aes = Aes.makeAes("angle");
        aes.required = true;
        aes.value = null;
        aes.defaultValue = null;
        stat.aess.add(aes);
        aes = Aes.makeAes("radius");
        stat.aess.add(aes);
        aes = Aes.makeAes("xend", null, "..xend..");
        stat.aess.add(aes);
        aes = Aes.makeAes("yend", null, "..yend..");
        stat.aess.add(aes);
        aes = Aes.makeAes("group");
        stat.aess.add(aes);
        stat.generated.add("xend");
        stat.generated.add("yend");
        return stat;
    }

    public static Stat makeSum() {
        Stat stat = new Stat();
        stat.name = "sum";
        stat.defaultGeom = "point";
        Aes aes = Aes.makeAes("x");
        stat.aess.add(aes);
        aes = Aes.makeAes("y");
        stat.aess.add(aes);
        aes = Aes.makeAes("size", null, "..prop..");
        stat.aess.add(aes);
        aes = Aes.makeAes("group");
        stat.aess.add(aes);
        stat.generated.add("n");
        stat.generated.add("prop");
        return stat;
    }

    public static Stat makeSummary() {
        Stat stat = new Stat();
        stat.name = "summary";
        stat.defaultGeom = "pointrange";
        Aes aes = Aes.makeAes("x");
        stat.aess.add(aes);
        aes = Aes.makeAes("y");
        stat.aess.add(aes);
        aes = Aes.makeAes("group");
        stat.aess.add(aes);
        ParamStatSummary paramStatSummary = new ParamStatSummary("Summary");
        stat.params.add(paramStatSummary);
        stat.generated.add("ymin");
        stat.generated.add("ymax");
        return stat;
    }

    public static Stat makeUnique() {
        Stat stat = new Stat();
        stat.name = "unique";
        stat.defaultGeom = "point";
        return stat;
    }

    public static Stat makeYDensity() {
        Stat stat = new Stat();
        stat.name = "ydensity";
        stat.defaultGeom = "violin";
        Aes aes = Aes.makeAes("x");
        aes.required = true;
        stat.aess.add(aes);
        aes = Aes.makeAes("y");
        aes.required = true;
        stat.aess.add(aes);
        aes = Aes.makeAes("group");
        stat.aess.add(aes);
        ParamCharacter paramCharacter = new ParamCharacter("scale");
        paramCharacter.setOptions(new String[]{"area", "count", "width"});
        paramCharacter.setViewType("org.rosuda.deducer.widgets.param.ParamComboBoxWidget");
        paramCharacter.setDefaultValue("equal");
        paramCharacter.setValue("equal");
        stat.params.add(paramCharacter);
        Param param = ParamFactory.makeParam("adjust");
        stat.params.add(param);
        param = ParamFactory.makeParam("kernel");
        stat.params.add(param);
        param = ParamFactory.makeParam("trim");
        stat.params.add(param);
        param = ParamFactory.makeParam("na.rm");
        stat.params.add(param);
        stat.generated.add("density");
        stat.generated.add("count");
        stat.generated.add("scaled");
        return stat;
    }

    public static Stat makeStat(String string) {
        if (string == "identity") {
            return Stat.makeIdentity();
        }
        if (string == "bin") {
            return Stat.makeBin();
        }
        if (string == "bin_2d") {
            return Stat.makeBin2d();
        }
        if (string == "bindot") {
            return Stat.makeBinDot();
        }
        if (string == "bin_hex") {
            return Stat.makeBinhex();
        }
        if (string == "boxplot") {
            return Stat.makeBoxplot();
        }
        if (string == "contour") {
            return Stat.makeContour();
        }
        if (string == "density") {
            return Stat.makeDensity();
        }
        if (string == "density_2d") {
            return Stat.makeDensity2d();
        }
        if (string == "ecdf") {
            return Stat.makeEcdf();
        }
        if (string == "function") {
            return Stat.makeFunction();
        }
        if (string == "qq") {
            return Stat.makeQq();
        }
        if (string == "quantile") {
            return Stat.makeQuantile();
        }
        if (string == "smooth") {
            return Stat.makeSmooth();
        }
        if (string == "spoke") {
            return Stat.makeSpoke();
        }
        if (string == "sum") {
            return Stat.makeSum();
        }
        if (string == "summary") {
            return Stat.makeSummary();
        }
        if (string == "unique") {
            return Stat.makeUnique();
        }
        if (string == "ydensity") {
            return Stat.makeYDensity();
        }
        if (string == "count") {
            return Stat.makeCount();
        }
        return null;
    }

    public Element toXML() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("Stat");
            element.setAttribute("className", "org.rosuda.deducer.plots.Stat");
            if (this.name != null) {
                element.setAttribute("name", this.name);
            }
            if (this.defaultGeom != null) {
                element.setAttribute("defaultGeom", this.defaultGeom);
            }
            Element element2 = document.createElement("params");
            for (int i = 0; i < this.params.size(); ++i) {
                Element element3 = ((Param)this.params.get(i)).toXML();
                element3 = (Element)document.importNode(element3, true);
                element2.appendChild(element3);
            }
            element.appendChild(element2);
            Element element4 = document.createElement("aess");
            for (int i = 0; i < this.aess.size(); ++i) {
                Element element5 = ((Aes)this.aess.get(i)).toXML();
                element5 = (Element)document.importNode(element5, true);
                element4.appendChild(element5);
            }
            element.appendChild(element4);
            Element element6 = document.createElement("generated");
            if (this.generated != null) {
                for (int i = 0; i < this.generated.size(); ++i) {
                    element6.setAttribute("element_" + i, this.generated.get(i).toString());
                }
            }
            element.appendChild(element6);
            document.appendChild(element);
            return element;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void setFromXML(Element element) {
        Object object;
        Object object2;
        int n;
        String string = element.getAttribute("className");
        if (!string.equals("org.rosuda.deducer.plots.Stat")) {
            System.out.println("Error Stat: class mismatch: " + string);
            new Exception().printStackTrace();
        }
        this.name = element.hasAttribute("name") ? element.getAttribute("name") : null;
        this.defaultGeom = element.hasAttribute("defaultGeom") ? element.getAttribute("defaultGeom") : null;
        Element element2 = (Element)element.getElementsByTagName("params").item(0);
        this.params = new Vector();
        Vector vector = XMLHelper.getChildrenElementsByTag(element2, "Param");
        for (n = 0; n < vector.size(); ++n) {
            object2 = (Element)vector.get(n);
            string = object2.getAttribute("className");
            object = Param.makeParam(string);
            ((Param)object).setFromXML((Element)object2);
            this.params.add(object);
        }
        element2 = (Element)element.getElementsByTagName("aess").item(0);
        this.aess = new Vector();
        vector = XMLHelper.getChildrenElementsByTag(element2, "Aes");
        for (n = 0; n < vector.size(); ++n) {
            object2 = (Element)vector.get(n);
            object = new Aes();
            ((Aes)object).setFromXML((Element)object2);
            this.aess.add(object);
        }
        this.generated = new Vector();
        Node node = element.getElementsByTagName("generated").item(0);
        object2 = node.getAttributes();
        if (object2.getLength() > 0) {
            for (int i = 0; i < object2.getLength(); ++i) {
                this.generated.add(object2.item(i).getNodeValue());
            }
        }
    }
}

