/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.widgets;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.widgets.DeducerWidget;

public class CheckBoxesWidget
extends JPanel
implements DeducerWidget {
    private JPanel TitledPanel;
    private String title;
    private Vector checkboxes;
    private Vector names = new Vector();
    private Vector initialModel;
    private Vector lastModel;

    public CheckBoxesWidget(String string, String[] stringArray, int n) {
        this.checkboxes = new Vector();
        this.title = string;
        for (int i = 0; i < stringArray.length; ++i) {
            this.names.add(stringArray[i]);
            JCheckBox jCheckBox = new JCheckBox();
            jCheckBox.setText(stringArray[i]);
            this.checkboxes.add(jCheckBox);
        }
        this.initGUI(n);
    }

    public CheckBoxesWidget(String[] stringArray, int n) {
        this(null, stringArray, n);
    }

    public CheckBoxesWidget(String[] stringArray) {
        this(null, stringArray, 1);
    }

    public CheckBoxesWidget(String string, String[] stringArray) {
        this(string, stringArray, 1);
    }

    private void initGUI(int n) {
        try {
            this.setLayout(new BorderLayout());
            this.setPreferredSize(new Dimension(191, 127));
            this.TitledPanel = new JPanel();
            this.TitledPanel.setLayout(new GridLayout(0, n));
            this.add((Component)this.TitledPanel, "Center");
            if (this.title != null) {
                this.TitledPanel.setBorder(BorderFactory.createTitledBorder(this.title));
            }
            for (int i = 0; i < this.checkboxes.size(); ++i) {
                JCheckBox jCheckBox = (JCheckBox)this.checkboxes.get(i);
                this.TitledPanel.add(jCheckBox);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Vector getBoxes() {
        return this.checkboxes;
    }

    public String[] getNames() {
        return (String[])this.names.toArray();
    }

    public String[] getSelectedItemText() {
        return (String[])((Vector)this.getModel()).toArray();
    }

    public JCheckBox[] getSelectedButtons() {
        Vector<JCheckBox> vector = new Vector<JCheckBox>();
        for (int i = 0; i < this.checkboxes.size(); ++i) {
            JCheckBox jCheckBox = (JCheckBox)this.checkboxes.get(i);
            if (!jCheckBox.isSelected()) continue;
            vector.add(jCheckBox);
        }
        return null;
    }

    public void setSelected(String string, boolean bl) {
        for (int i = 0; i < this.checkboxes.size(); ++i) {
            JCheckBox jCheckBox = (JCheckBox)this.checkboxes.get(i);
            if (!jCheckBox.getText().equals(string)) continue;
            jCheckBox.setSelected(bl);
        }
    }

    public void setSelected(JCheckBox jCheckBox, boolean bl) {
        this.setSelected(jCheckBox.getText(), bl);
    }

    public void setDefaultModel(String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        this.setDefaultModel(vector);
    }

    public void setDefaultModel(String string) {
        Vector<String> vector = new Vector<String>();
        vector.add(string);
        this.setDefaultModel(vector);
    }

    public void addButton(JCheckBox jCheckBox) {
        this.TitledPanel.add(jCheckBox);
        this.checkboxes.add(jCheckBox);
        this.names.add(jCheckBox.getText());
    }

    public void addButton(String string) {
        JCheckBox jCheckBox = new JCheckBox(string);
        this.TitledPanel.add(jCheckBox);
        this.checkboxes.add(jCheckBox);
        this.names.add(jCheckBox.getText());
    }

    public void removeButton(int n) {
        JCheckBox jCheckBox = (JCheckBox)this.checkboxes.remove(n);
        if (jCheckBox != null) {
            this.names.remove(n);
            this.TitledPanel.remove(jCheckBox);
        }
    }

    public void addListener(EventListener eventListener) {
        for (int i = 0; i < this.checkboxes.size(); ++i) {
            JCheckBox jCheckBox = (JCheckBox)this.checkboxes.get(i);
            if (eventListener instanceof ActionListener) {
                jCheckBox.addActionListener((ActionListener)eventListener);
            }
            if (!(eventListener instanceof MouseListener)) continue;
            jCheckBox.addMouseListener((MouseListener)eventListener);
        }
    }

    public Object getModel() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.checkboxes.size(); ++i) {
            JCheckBox jCheckBox = (JCheckBox)this.checkboxes.get(i);
            if (!jCheckBox.isSelected()) continue;
            vector.add(jCheckBox.getText());
        }
        return vector;
    }

    public String getRModel() {
        Vector vector = (Vector)this.getModel();
        return Deducer.makeRCollection(vector, "c", true);
    }

    public String getTitle() {
        return this.title;
    }

    public void reset() {
        this.setModel(this.initialModel);
    }

    public void resetToLast() {
        this.setModel(this.lastModel);
    }

    public void setDefaultModel(Object object) {
        if (object == null) {
            this.initialModel = new Vector();
            if (this.lastModel == null) {
                this.lastModel = new Vector();
            }
        } else {
            this.initialModel = (Vector)object;
            if (this.lastModel == null) {
                this.lastModel = (Vector)object;
            }
        }
    }

    public void setLastModel(Object object) {
        this.lastModel = object == null ? new Vector() : (Vector)object;
    }

    public void setModel(Object vector) {
        int n;
        if (vector == null) {
            vector = new Vector();
        }
        for (n = 0; n < this.checkboxes.size(); ++n) {
            ((JCheckBox)this.checkboxes.get(n)).setSelected(false);
        }
        for (n = 0; n < vector.size(); ++n) {
            String string = (String)vector.get(n);
            for (int i = 0; i < this.checkboxes.size(); ++i) {
                String string2 = (String)this.names.get(i);
                if (!string2.equals(string)) continue;
                ((JCheckBox)this.checkboxes.get(i)).setSelected(true);
            }
        }
    }

    public void setTitle(String string, boolean bl) {
        this.title = string;
        if (string == null) {
            this.setBorder(BorderFactory.createEmptyBorder());
        } else if (bl) {
            this.setBorder(BorderFactory.createTitledBorder(this.title));
        }
    }

    public void setTitle(String string) {
        this.setTitle(string, false);
    }
}

