/*
 * Decompiled with CFR 0.152.
 */
package edu.cens.spatial;

import edu.cens.spatial.DeducerSpatial;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.io.File;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.toolkit.FileSelector;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.toolkit.HelpButton;

public class ShapeFileLoader
extends FileSelector {
    private static final String HELP_URL = "index.php?n=Main.DeducerSpatial";
    private JTextField rDataNameField;
    JTextField proj;

    public ShapeFileLoader(Frame frame) {
        super(frame, "Load shape file", 0, null, true);
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(new JLabel("Set name: "));
        this.rDataNameField = new JTextField(12);
        jPanel.add(this.rDataNameField);
        jPanel.add(new JLabel("      Proj: "));
        this.proj = new JTextField(10);
        this.proj.setText("+proj=longlat +datum=WGS84");
        jPanel.add(this.proj);
        jPanel.add((Component)new HelpButton(HELP_URL));
        this.addFooterPanel(jPanel);
        if (this.isSwing()) {
            this.getJFileChooser().addChoosableFileFilter(new FileFilter(){

                public String getDescription() {
                    return "Shape Files (*.shp *.dbf *.prj *.sbn *.sbx)";
                }

                public boolean accept(File file) {
                    String string = file.getName().toLowerCase();
                    return string.toLowerCase().endsWith(".shp") || string.toLowerCase().endsWith(".dbf") || string.toLowerCase().endsWith(".prj") || string.toLowerCase().endsWith(".sbn") || string.toLowerCase().endsWith(".sbx") || file.isDirectory();
                }
            });
        }
        DeducerSpatial.rgdalCheck();
    }

    public ShapeFileLoader() {
        this(null);
    }

    public boolean runInR() {
        if (this.getFile() == null) {
            return false;
        }
        String string = this.rDataNameField.getText();
        if (string.length() == 0) {
            string = this.getFile().indexOf(".") <= 0 ? Deducer.getUniqueName((String)this.getFile()) : Deducer.getUniqueName((String)this.getFile().substring(0, this.getFile().indexOf(".")));
        }
        string = RController.makeValidVariableName((String)string);
        String string2 = (this.getDirectory() + Deducer.addSlashes((String)this.getFile())).replace('\\', '/');
        if (!(string2.toLowerCase().endsWith(".shp") || string2.toLowerCase().endsWith(".shp") || string2.toLowerCase().endsWith(".dbf") || string2.toLowerCase().endsWith(".prj") || string2.toLowerCase().endsWith(".sbn") || string2.toLowerCase().endsWith(".sbx"))) {
            JOptionPane.showMessageDialog((Component)((Object)this), "This does not appear to be a shape file.\nAcceptable extensions are: .shp,.dbf,.prj,.sbx,.sbn");
            return false;
        }
        string2 = string2.substring(0, string2.length() - 4);
        String string3 = string + " <- readShapeSpatial(\"" + string2 + "\", proj=CRS('" + this.proj.getText() + "'))\n";
        string3 = string3 + string + " <- spTransform(" + string + ",osm())";
        Deducer.execute((String)string3);
        return true;
    }
}

