print.diag <- function(x,...)
{
options(digits=4)
cat("\n\n")
print(x$tabmarg)
cat("\n\n")
cat("The test has the following parameters [95% confidence interval]\n")
cat("Sample size: ",x$n,"\n")
cat("Prevalence considered: ",(x$p)*100,"%\n")
cat("Sensitivity: ",(x$Se)*100,"% [",(x$Se.ci[1])*100," : ",(x$Se.ci[2])*100,"]\n")
cat("Specificity: ",(x$Sp)*100,"% [",(x$Sp.ci[1])*100," : ",(x$Sp.ci[2])*100,"]\n")
cat("Positive predictive value: ",(x$PPV)*100,"% [",(x$PPV.ci[1])*100," : ",(x$PPV.ci[2])*100,"]\n")
cat("Negative predictive value: ",(x$NPV)*100,"% [",(x$NPV.ci[1])*100," : ",(x$NPV.ci[2])*100,"]\n")
cat("Positive likelihood ratio: ",(x$PLR),"\n")
cat("Negative likelihood ratio: ",(x$NLR),"\n")
cat("Diagnostic odds ratio: ",(x$DOR)," [",(x$DOR.ciI)," : ",(x$DOR.ciS),"]\n")
cat("Error trade off (FN : FP) (",x$ET," : 1 )\n")
cat("Error rate: ",(x$ER)*100,"% [",(x$ER.ci[1])*100," : ",(x$ER.ci[2])*100,"]\n")
cat("Accuracy: ",(x$accu)*100,"% [",(x$accu.ci[1])*100," : ",(x$accu.ci[2])*100,"]\n")
cat("Area under ROC curve: ",(x$AUC),"\n")
options(digits=7)
}
