% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/remove_from_series.R
\name{remove_from_series}
\alias{remove_from_series}
\title{Remove graph object from a graph series object}
\usage{
remove_from_series(graph_series, index = "last")
}
\arguments{
\item{graph_series}{a graph series object from which the graph object will be removed.}

\item{index}{the index of the graph object to be removed from the graph series object.}
}
\value{
a graph series object of type \code{dgr_graph_1D}.
}
\description{
Remove a single graph object from an array of graph objects in a graph series object.
}
\examples{
\dontrun{
# Create three graphs (using \\code{pipeR} for speed)
# and create a graph series using those graphs
library(pipeR)

graph_1 <- create_graph() \%>>\%
  add_node("a") \%>>\% add_node("b") \%>>\% add_node("c") \%>>\%
  add_edges(from = c("a", "a", "b"),
            to =   c("c", "b", "c"))

graph_2 <- graph_1 \%>>\%
  add_node("d") \%>>\% add_edges(from = "d", to = "c")

graph_3 <- graph_2 \%>>\%
  add_node("e") \%>>\% add_edges(from = "e", to = "b")

# Create an empty graph series
series <- create_series(series_type = "sequential")

# Add graphs to the graph series
series <- graph_1 \%>>\% add_to_series(series)
series <- graph_2 \%>>\% add_to_series(series)
series <- graph_3 \%>>\% add_to_series(series)

# Remove the second graph from the graph series
series <- remove_from_series(graph_series = series, index = 2)
}
}

