% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/add_edges.R
\name{add_edges}
\alias{add_edges}
\title{Add edges to an existing graph object}
\usage{
add_edges(graph, edges_df = NULL, from = NULL, to = NULL, rel = NULL)
}
\arguments{
\item{graph}{a graph object of class \code{dgr_graph} that is created using
\code{create_graph}.}

\item{edges_df}{an edge data frame that is created using \code{create_edges}.}

\item{from}{a vector of the outgoing nodes from which each edge is connected.}

\item{to}{a vector of the incoming nodes to which each edge is connected.}

\item{rel}{a string specifying the relationship between the
connected nodes.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
With a graph object of class \code{dgr_graph}, add one or more
edges of specified types to nodes within the graph.
}
\examples{
\dontrun{
# Create a graph with two nodes
graph <- create_graph(create_nodes(nodes = c("a", "b")))

# Add an edge between those nodes and attach a relationship to the edge
graph <- add_edges(graph, from = "a", to = "b",
                   rel = "to_get")

# Examples of pipeable graph building using 'create_edges' with
# 'add_edges' in order to include values for the 'style' edge attribute
# (it modifies the style of the connecting line)

library(magrittr)

graph <- create_graph() \%>\%
  add_node("a") \%>\%
  add_node("b") \%>\%
  add_edges(create_edges(from = "a", to = "b",
                         style = "solid")) \%>\%
  add_node("c") \%>\%
  add_node("d") \%>\%
  add_edges(create_edges(from = "c", to = "d",
                         style = "dashed")) \%>\%
  add_node("e") \%>\%
  add_node("f") \%>\%
  add_edges(create_edges(from = "e", to = "f",
                         style = "dotted")) \%>\%
  add_node("g") \%>\%
  add_node("h") \%>\%
  add_edges(create_edges(from = "g", to = "h",
                         style = "bold"))
}
}

