% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/invert_selection.R
\name{invert_selection}
\alias{invert_selection}
\title{Invert selection of nodes or edges in a graph}
\usage{
invert_selection(graph)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph} that is created using
\code{create_graph}.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
Modify the selection of nodes or edges
within a graph object such that all nodes or edges
previously unselected will now be selected and vice
versa.
}
\examples{
# Create a node data frame (ndf)
nodes <-
  create_nodes(
    nodes = c("a", "b", "c", "d"),
    type = "letter")

# Create an edge data frame (edf)
edges <-
  create_edges(
    from = c("a", "b", "c"),
    to = c("d", "c", "a"),
    rel = "leading_to")

# Create a graph
graph <-
  create_graph(nodes_df = nodes,
               edges_df = edges)

# Select nodes `a` and `c`
graph <-
  select_nodes(
    graph = graph,
    nodes = c("a", "c"))

# Verify that a node selection has been made
get_selection(graph)
#> $nodes
#> [1] "a" "c"

# Invert the selection
graph <- invert_selection(graph = graph)

# Verify that the node selection has been changed
get_selection(graph)
#> $nodes
#> [1] "b" "d"
}

