% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/visnetwork.R
\name{visnetwork}
\alias{visnetwork}
\title{Render graph with visNetwork}
\usage{
visnetwork(graph)
}
\arguments{
\item{graph}{a \code{dgr_graph} object, created using the
\code{create_graph} function.}
}
\description{
Render a graph object with the visNetwork R package.
}
\examples{
\dontrun{
# Create a node data frame
nodes <-
  create_nodes(nodes = c("a", "b", "c", "d", "e", "f"),
               label = TRUE,
               fillcolor = c("lightgrey", "red", "orange", "pink",
                         "aqua", "yellow"),
               shape = "circle",
               value = c(2, 1, 0.5, 1, 1.8, 1),
               type = c("1", "1", "1", "2", "2", "2"),
               x = c(1, 2, 3, 4, 5, 6),
               y = c(-2, -1, 0, 6, 4, 1))

# Create an edge data frame
edges <-
  create_edges(from = c("a", "b", "c", "d", "f", "e"),
               to = c("d", "c", "a", "c", "a", "d"),
               color = c("green", "green", "grey", "grey",
                         "blue", "blue"),
               rel = "leading_to")

# Create a graph object
graph <- create_graph(nodes_df = nodes,
                      edges_df = edges)

visnetwork(graph)
}
}

