% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_graph_undirected.R
\name{set_graph_undirected}
\alias{set_graph_undirected}
\title{Convert graph to an undirected graph}
\usage{
set_graph_undirected(graph)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
Take a graph which is directed and
convert it to an undirected graph.
}
\examples{
# Create a graph with a directed tree
graph <-
  create_graph() \%>\%
  add_balanced_tree(2, 2)

# Convert this graph from directed to undirected
graph <- graph \%>\% set_graph_undirected()

# Perform a check on whether graph is directed
graph \%>\% is_graph_directed()
#> [1] FALSE
}

