% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_igraph.R
\name{to_igraph}
\alias{to_igraph}
\title{Convert a DiagrammeR graph to an igraph one}
\usage{
to_igraph(graph)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}
}
\value{
an igraph object.
}
\description{
Convert a DiagrammeR graph to
an igraph graph object.
}
\examples{
# Create a DiagrammeR graph object
graph <-
  create_random_graph(
    36, 50, set_seed = 1)

# Confirm that `graph` is a DiagrammeR graph
# by getting the object's class
class(graph)
#> [1] "dgr_graph"

# Convert the DiagrammeR graph to an igraph object
ig_graph <- to_igraph(graph)

# Get the class of the converted graph, just
# to be certain
class(ig_graph)
#> [1] "igraph"

# Get a summary of the igraph graph object
summary(ig_graph)
#> IGRAPH UN-B 36 50 --
#> + attr: name (v/c), type (v/c), label
#> | (v/c), value (v/c), rel (e/c)
}

