% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_n_node_clones.R
\name{add_n_node_clones}
\alias{add_n_node_clones}
\title{Add one or several clones of an existing node to the graph}
\usage{
add_n_node_clones(graph, n, node, label = NULL)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{n}{the number of node clones to add to the graph.}

\item{node}{a node ID corresponding to the graph node
to be cloned.}

\item{label}{an optional vector of node label values.
The vector length should correspond to the value set
for \code{n}.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
Add n new nodes to a graph object of
class \code{dgr_graph} which are clones of a node already
in the graph. All node attributes are preserved except for
the node \code{label} attribute (to maintain the
uniqueness of non-\code{NA} node label values). A vector
of node \code{label} can be provided to bind new labels
to the cloned nodes.
}
\examples{
# Create a graph with a path of
# nodes; supply `label`, `type`,
# and `value` node attributes
graph <-
  create_graph() \%>\%
  add_path(
    n = 3,
    label = c("d", "g", "r"),
    type = c("a", "b", "c"),
    value = c(10, 20, 30))

# Display the graph's internal
# node data frame
graph \%>\%
  get_node_df()
#>   id type label value
#> 1  1    a     d    10
#> 2  2    b     g    20
#> 3  3    c     r    30

# Create 3 clones of node `1`
# but assign new node label
# values (leaving `label` as
# NULL yields NA values)
graph <-
  graph \%>\%
  add_n_node_clones(
    n = 3,
    node = 1,
    label = c("x", "y", "z"))

# Display the graph's internal
# node data frame: nodes `4`,
# `5`, and `6` are clones of `1`
graph \%>\%
  get_node_df()
#>   id type label value
#> 1  1    a     d    10
#> 2  2    b     g    20
#> 3  3    c     r    30
#> 4  4    a     x    10
#> 5  5    a     y    10
#> 6  6    a     z    10
}
