% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_unconnected_node_pairs.R
\name{count_unconnected_node_pairs}
\alias{count_unconnected_node_pairs}
\title{Get the number of unconnected node pairs}
\usage{
count_unconnected_node_pairs(graph)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}
}
\value{
a single numeric value representing the
number of unconnected node pairs.
}
\description{
Get the number of unconnected
node pairs. This works for directed graphs.
}
\examples{
# Create a cycle graph
graph <-
  create_graph() \%>\%
  add_cycle(n = 5)

# Get a count of unconnected node
# pairs in the graph
count_unconnected_node_pairs(graph)
#> [1] 5

# Create a full graph and then
# count all unconnected node pairs
create_graph() \%>\%
  add_full_graph(n = 10) \%>\%
  count_unconnected_node_pairs()
#> [1] 0
}
