% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_graph_connected.R
\name{is_graph_connected}
\alias{is_graph_connected}
\title{Is the graph a connected graph?}
\usage{
is_graph_connected(graph)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}
}
\value{
a logical value.
}
\description{
Determines whether a graph is a
connected graph.
}
\examples{
# Create a random graph using the
# `add_gnm_graph()` function; this
# graph is not connected
create_graph() \%>\%
  add_gnm_graph(
    n = 15,
    m = 10,
    set_seed = 23) \%>\%
  is_graph_connected()

# Create another random graph;
# this graph is connected
create_graph() \%>\%
  add_gnm_graph(
    n = 10,
    m = 15,
    set_seed = 23) \%>\%
  is_graph_connected()
}
