% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_node.R
\name{add_node}
\alias{add_node}
\title{Add a node to an existing graph object}
\usage{
add_node(
  graph,
  type = NULL,
  label = NULL,
  from = NULL,
  to = NULL,
  node_aes = NULL,
  edge_aes = NULL,
  node_data = NULL,
  edge_data = NULL
)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{type}{An optional character object that acts as a group identifier for
the node to be added.}

\item{label}{An optional character object that describes the node.}

\item{from}{An optional vector containing node IDs from which edges will be
directed to the new node.}

\item{to}{An optional vector containing node IDs to which edges will be
directed from the new node.}

\item{node_aes}{An optional list of named vectors comprising node aesthetic
attributes. The helper function \code{\link[=node_aes]{node_aes()}} is strongly recommended for
use here as it contains arguments for each of the accepted node aesthetic
attributes (e.g., \code{shape}, \code{style}, \code{color}, \code{fillcolor}).}

\item{edge_aes}{An optional list of named vectors comprising edge aesthetic
attributes. The helper function \code{\link[=edge_aes]{edge_aes()}} is strongly recommended for
use here as it contains arguments for each of the accepted edge aesthetic
attributes (e.g., \code{shape}, \code{style}, \code{penwidth}, \code{color}).}

\item{node_data}{An optional list of named vectors comprising node data
attributes. The helper function \code{\link[=node_data]{node_data()}} is strongly recommended for
use here as it helps bind data specifically to the created nodes.}

\item{edge_data}{An optional list of named vectors comprising edge data
attributes. The helper function \code{\link[=edge_data]{edge_data()}} is strongly recommended for
use here as it helps bind data specifically to the created edges.}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
With a graph object of class \code{dgr_graph}, add a new node to the graph. One
can optionally provide node attributes for the created node. There is also
the option to create edges to and from existing nodes in the graph. Because
new edges can also be created through this function, there is the possibility
to set edge attributes for any new graph edges.
}
\examples{
# Create an empty graph and add 2 nodes by using
# the `add_node()` function twice
graph <-
  create_graph() \%>\%
  add_node() \%>\%
  add_node()

# Get a count of all nodes
# in the graph
graph \%>\% count_nodes()

# The nodes added were given
# ID values `1` and `2`; obtain
# the graph's node IDs
graph \%>\% get_node_ids()

# Add a node with a `type`
# value defined
graph <-
  graph \%>\%
  add_node(type = "person")

# View the graph's internal
# node data frame (ndf)
graph \%>\% get_node_df()

}
\seealso{
Other Node creation and removal: 
\code{\link{add_n_node_clones}()},
\code{\link{add_n_nodes_ws}()},
\code{\link{add_n_nodes}()},
\code{\link{add_node_clones_ws}()},
\code{\link{add_node_df}()},
\code{\link{add_nodes_from_df_cols}()},
\code{\link{add_nodes_from_table}()},
\code{\link{colorize_node_attrs}()},
\code{\link{copy_node_attrs}()},
\code{\link{create_node_df}()},
\code{\link{delete_nodes_ws}()},
\code{\link{delete_node}()},
\code{\link{drop_node_attrs}()},
\code{\link{join_node_attrs}()},
\code{\link{layout_nodes_w_string}()},
\code{\link{mutate_node_attrs_ws}()},
\code{\link{mutate_node_attrs}()},
\code{\link{node_data}()},
\code{\link{recode_node_attrs}()},
\code{\link{rename_node_attrs}()},
\code{\link{rescale_node_attrs}()},
\code{\link{set_node_attr_to_display}()},
\code{\link{set_node_attr_w_fcn}()},
\code{\link{set_node_attrs_ws}()},
\code{\link{set_node_attrs}()},
\code{\link{set_node_position}()}
}
\concept{Node creation and removal}
