% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node_data.R
\name{node_data}
\alias{node_data}
\title{Insert node data attributes during node creation}
\usage{
node_data(...)
}
\arguments{
\item{...}{Node data attributes provided as one or more named vectors.}
}
\description{
This helper function should be invoked to provide values for the namesake
\code{node_data} argument, which is present in any function where nodes are
created.
}
\examples{
# Create a new graph and add
# a path with several node
# data attributes
graph <-
  create_graph() \%>\%
  add_path(
    n = 3,
    type = "path",
    node_data = node_data(
      hour = 5,
      index = c(1, 3, 2)))

# View the graph's internal
# node data frame; the node
# data attributes have been
# inserted
graph \%>\% get_node_df()
}
\seealso{
Other Node creation and removal: 
\code{\link{add_n_node_clones}()},
\code{\link{add_n_nodes_ws}()},
\code{\link{add_n_nodes}()},
\code{\link{add_node_clones_ws}()},
\code{\link{add_node_df}()},
\code{\link{add_nodes_from_df_cols}()},
\code{\link{add_nodes_from_table}()},
\code{\link{add_node}()},
\code{\link{colorize_node_attrs}()},
\code{\link{copy_node_attrs}()},
\code{\link{create_node_df}()},
\code{\link{delete_nodes_ws}()},
\code{\link{delete_node}()},
\code{\link{drop_node_attrs}()},
\code{\link{join_node_attrs}()},
\code{\link{layout_nodes_w_string}()},
\code{\link{mutate_node_attrs_ws}()},
\code{\link{mutate_node_attrs}()},
\code{\link{recode_node_attrs}()},
\code{\link{rename_node_attrs}()},
\code{\link{rescale_node_attrs}()},
\code{\link{set_node_attr_to_display}()},
\code{\link{set_node_attr_w_fcn}()},
\code{\link{set_node_attrs_ws}()},
\code{\link{set_node_attrs}()},
\code{\link{set_node_position}()}
}
\concept{Node creation and removal}
