% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hayman.R
\name{Hayman}
\alias{Hayman}
\title{Diallel Analysis using Hayman Approach}
\usage{
Hayman(y, Rep, Cross1, Cross2, data)
}
\arguments{
\item{y}{Numeric Response Vector}

\item{Rep}{Replicate as factor}

\item{Cross1}{Cross 1 as factor}

\item{Cross2}{Cross 2 as factor}

\item{data}{A \code{data.frame}}
}
\value{
Means Means

ANOVA Analysis of Variance (ANOVA) table

Genetic.Components Genetic Components

Effects Effects of Crosses

StdErr Standard Errors of Crosses
}
\description{
\code{Hayman} is used for performing Diallel Analysis using Hayman's Approach.
}
\details{
Diallel Analysis using Haymans's approach.
}
\examples{
#------------------------------------------
## Diallel Analysis with Haymans's Aproach
#------------------------------------------

Hayman1Data <-
 Hayman(
     y      = Yield
   , Rep    = Rep
   , Cross1 = Cross1
   , Cross2 = Cross2
   , data   = HaymanData
   )

Hayman1Data
names(Hayman1Data)

Hayman1DataMeans <- Hayman1Data$Means
Hayman1DataANOVA <- Hayman1Data$ANOVA
Hayman1DataWr.Vr.Table <- Hayman1Data$Wr.Vr.Table

Hayman1DataComponents.of.Variation <- Hayman1Data$Components.of.Variation
Hayman1DataOther.Parameters <- Hayman1Data$Other.Parameters
Hayman1DataFr <- Hayman1Data$Fr

#----------------
# Wr-Vr Graph
#----------------
VOLO     <- Hayman1Data$VOLO
In.Value <- Hayman1Data$In.Value
a        <- Hayman1Data$a
b        <- Hayman1Data$b
Wr.Vr    <- Hayman1Data$Wr.Vr.Table


library(ggplot2)
ggplot(data=data.frame(x=c(0, max(In.Value, Wr.Vr$Vr, Wr.Vr$Wr, Wr.Vr$Wrei))), aes(x)) +
  stat_function(fun=function(x) {sqrt(x*VOLO)}, color="blue") +
  geom_hline(yintercept = 0) +
  geom_vline(xintercept = 0) +
  geom_abline(intercept = a, slope = b) +
  geom_abline(intercept = mean(Wr.Vr$Wr)-mean(Wr.Vr$Vr), slope = 1) +
  geom_segment(aes(
      x     = mean(Wr.Vr$Vr)
    , y     = min(0, mean(Wr.Vr$Wr))
    , xend  = mean(Wr.Vr$Vr)
    , yend  = max(0, mean(Wr.Vr$Wr))
  )
  , color = "green"
  ) +
  geom_segment(aes(
      x     = min(0, mean(Wr.Vr$Vr))
    , y     = mean(Wr.Vr$Wr)
    , xend  = max(0, mean(Wr.Vr$Vr))
    , yend  = mean(Wr.Vr$Wr)
  )
  , color = "green"
  )  +
  lims(x=c(min(0, Wr.Vr$Vr, Wr.Vr$Wrei), max(Wr.Vr$Vr, Wr.Vr$Wrei)),
       y=c(min(0, Wr.Vr$Wr, Wr.Vr$Wrei), max(Wr.Vr$Wr, Wr.Vr$Wri))
  ) +
  labs(
         x = expression(V[r])
       , y = expression(W[r])
       , title = expression(paste(W[r]-V[r] , " Graph"))
       ) +
  theme_bw()
}
\references{
\enumerate{
\item Hayman, B. I. (1954 a) The Theory and Analysis of Diallel Crosses.
             \emph{Genetics},
             \strong{39}, 789--809.
\item Hayman, B. I. (1954 b) The Analysis of Variance of Diallel Tables.
             \emph{Biometrics},
             \strong{10}, 235--244.
\item Hayman, B. I. (1957) Interaction, Heterosis and Diallel Crosses.
             \emph{Genetics},
             \strong{42}, 336--355.
\item Singh, R. K. and Chaudhary, B. D. (2004) \emph{Biometrical Methods in Quantitative Genetic Analysis}.
             New Delhi: Kalyani.
 }
}
\seealso{
\code{\link{Griffing}}
 , \code{\link{HaymanData}}
}
\author{
Muhammad Yaseen (\email{myaseen208@gmail.com})
}
