% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Aux_fun.R
\name{build.stepfuns}
\alias{build.stepfuns}
\title{Building step functions from \code{pCDFlist}}
\usage{
build.stepfuns(pCDFlist)
}
\arguments{
\item{pCDFlist}{a list of the supports of the CDFs of the p-values. Each support is represented by a vector that must be in increasing order.}
}
\value{
A list of CDFs.
}
\description{
Creates a list of step functions out of p-value
CDF supports. That is, creates the list of the CDFs.
The end user should not use it.
}
\details{
The functions returned are the ones denoted by \eqn{F_i} in the
reference paper, see \code{\link{DiscreteFDR}}.

This version: 2017-09-09.
}
\examples{
toyList <- list(c(0.3,0.7,1),c(0.1,0.65,1))
toyStep <- build.stepfuns(toyList)
toyStep[[1]](0.2)
toyStep[[2]](0.2)
toyStep[[1]](0.65)
toyStep[[2]](0.65)

}
\seealso{
\code{\link{discrete.BH}}, \code{\link{DBR}}
}
