% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BeersProjectiveMapping.R
\docType{data}
\name{BeersProjectiveMapping}
\alias{BeersProjectiveMapping}
\alias{BeersProjectiveNapping}
\title{7 (fictitious) assessors sort and verbally describe 7 Beers using
\emph{Projective Mapping}.}
\format{
a list with 3 elements:
1) \code{ProjectiveMapping}: 
a matrix of dimensions 7 beers by  7*2 
assessors-dimensions of the coordinates of the beers on the sheet
of paper;
2) \code{Vocabulary}: a Beers (rows) by Assessors (columns)
 data.frame 
 where each element of \code{Vocabulary}
stores
the words used by one assessor to describe a beer
(words are separated with spaces);
and 3) \code{CT.vocabulary} a matrix storing
the  \eqn{I} Products by \eqn{N} 
 words (from the Vocabulary) contingency table,
 in  \code{CT.vocabulary} the number at the intersection
 of a row (beer) and a column (word) is the number
 of assessors who used this word to describe that beer.
}
\source{
Abdi, H,  & Valentin, D. (2007). 
\url{https://personal.utdallas.edu/~herve/}
}
\usage{
data("BeersProjectiveMapping")
}
\description{
\code{BeersProjectiveMapping}:
7 (fictitious) assessors evaluated 7 Beers using
\emph{Projective Mapping} (with verbal description).
}
\details{
First, Each assessor positioned the 7 beers on a sheet
of paper according to the perceived similarity between the beers.
For each assessor, the position of the beers was recorded
from the \eqn{X} and \eqn{Y} coordinates. 
Second, the assessors were asked if they could describe each
beer with some freely chosen descriptors. 
These descriptors
are stored in a dataframe with 7 elements (one per assessor)
where each element of the dataframe
is a 7 component vector (one per beer) where each element stores
the words used to describe a beer 
(words are separated with spaces).
}
\references{
Abdi, H., & Valentin, D., (2007). 
Some new and easy ways to describe, compare, 
and evaluate products and assessors. 
In D., Valentin, D.Z. Nguyen, L. Pelletier (Eds) 
\emph{New trends in sensory evaluation 
of food and non-food products}.
Ho Chi Minh (Vietnam): 
Vietnam National University & Ho Chi Minh City Publishing House. 
pp. 5-18.
}
\author{
Hervé Abdi
}
\keyword{DistatisR}
\keyword{datasets}
