% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics-CloudProvider.R
\name{getDockerServerIp}
\alias{getDockerServerIp}
\title{Get the server IP and port}
\usage{
getDockerServerIp(provider, cluster, verbose)
}
\arguments{
\item{provider}{S4 \code{CloudProvider} object. The service provider.}

\item{cluster}{S4 \code{DockerCluster} object.}

\item{verbose}{Integer. The verbose level, default 1.}
}
\value{
a name list with four elements \code{publicIp}, \code{publicPort}, \code{privateIp}
and \code{privatePort}.
}
\description{
Get the server public/private IPs. The IPs will be used by the cluster to
make connections between server and worker, server and client. If the server
does not have the public or private IP, its value can be set to character(0) and port
can be set to integer(0).
If the IP has not been assigned yet, this function should wait until the IP is
available.
If the server is not provided by the cloud provider, this function will not be called.
There is no default method for this generic. The return value should be a name list
with four elements \code{publicIp}, \code{publicPort}, \code{privateIp} and \code{privatePort}.
If the server does not have the public endpoint, public IP and port can be \code{NULL}.
}
