% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/BoxCoxES.R
\name{BoxCoxES}
\alias{BoxCoxES}
\title{Estimates ES with Box-Cox transformation}
\usage{
BoxCoxES(loss.data, cl)
}
\arguments{
\item{loss.data}{Daily Profit/Loss data}

\item{cl}{Confidence Level. It can be a scalar or a vector.}
}
\value{
Estimated Box-Cox ES. Its dimension is same as that of cl
}
\description{
Function estimates the ES of a portfolio assuming P and L data set transformed
using the BoxCox transformation to make it as near normal as possible, for
specified confidence level and holding period implied by data frequency.
}
\examples{
# Estimates Box-Cox VaR
   a<-rnorm(200)
   BoxCoxES(a,.95)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.

Hamilton, S. A. and Taylor, M. G. A Comparision of the Box-Cox
transformation method and nonparametric methods for estimating quantiles
in clinical data with repeated measures. J. Statist. Comput. Simul., vol.
45, 1993, pp. 185 - 201.
}

