% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/LogNormalES.R
\name{LogNormalES}
\alias{LogNormalES}
\title{ES for normally distributed geometric returns}
\usage{
LogNormalES(...)
}
\arguments{
\item{...}{The input arguments contain either return data or else mean and
 standard deviation data. Accordingly, number of input arguments is either 4
 or 5. In case there 4 input arguments, the mean and standard deviation of
 data is computed from return data. See examples for details.

 returns Vector of daily geometric return data

 mu Mean of daily geometric return data

 sigma Standard deviation of daily geometric return data

 investment Size of investment

 cl VaR confidence level

 hp VaR holding period in days}
}
\value{
Matrix of ES whose dimension depends on dimension of hp and cl. If
cl and hp are both scalars, the matrix is 1 by 1. If cl is a vector and hp is
 a scalar, the matrix is row matrix, if cl is a scalar and hp is a vector,
 the matrix is column matrix and if both cl and hp are vectors, the matrix
 has dimension length of cl * length of hp.
}
\description{
Estimates the ES of a portfolio assuming that geometric returns are
normally distributed, for specified confidence level and holding period.
}
\examples{
# Computes ES given geometric return data
   data <- runif(5, min = 0, max = .2)
   LogNormalES(returns = data, investment = 5, cl = .95, hp = 90)

   # Computes ES given mean and standard deviation of return data
   LogNormalES(mu = .012, sigma = .03, investment = 5, cl = .95, hp = 90)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.
}

