% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tVaRPlot2DHP.R
\name{tVaRPlot2DHP}
\alias{tVaRPlot2DHP}
\title{Plots t VaR against holding period}
\usage{
tVaRPlot2DHP(...)
}
\arguments{
\item{...}{The input arguments contain either return data or else mean and
 standard deviation data. Accordingly, number of input arguments is either 4
 or 5. In case there 4 input arguments, the mean and standard deviation of
 data is computed from return data. See examples for details.

 returns Vector of daily P/L data data

 mu Mean of daily P/L data data

 sigma Standard deviation of daily P/L data data

 df Number of degrees of freedom in the t distribution

 cl VaR confidence level and must be a scalar

 hp VaR holding period and must be a vector}
}
\description{
Plots the VaR of a portfolio against holding period assuming that P/L are
t- distributed, for specified confidence level and holding period.
}
\examples{
# Computes VaR given P/L data data
   data <- runif(5, min = 0, max = .2)
   tVaRPlot2DHP(returns = data, df = 6, cl = .95, hp = 60:90)

   # Computes VaR given mean and standard deviation of return data
   tVaRPlot2DHP(mu = .012, sigma = .03, df = 6, cl = .99, hp = 40:80)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.
}

