% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pattern.R
\name{stratifyByUnit}
\alias{stratifyByUnit}
\title{Function to stratify a conceptSetList by unit}
\usage{
stratifyByUnit(conceptSetList, cdm, ingredientConceptId)
}
\arguments{
\item{conceptSetList}{List of concept sets}

\item{cdm}{cdm reference}

\item{ingredientConceptId}{ConceptId that refers to an ingredient}
}
\value{
The conceptSetList stratified by unit
}
\description{
Function to stratify a conceptSetList by unit
}
\examples{
\donttest{
library(DrugUtilisation)
library(CodelistGenerator)

cdm <- mockDrugUtilisation()

codelist <- getDrugIngredientCodes(cdm, "acetaminophen")

codelistStratified <- stratifyByUnit(codelist, cdm, 1125315)

codelistStratified
}

}
