% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate_control_chart.R
\name{evaluate_control_chart_one_group}
\alias{evaluate_control_chart_one_group}
\title{Evaluate Control Charts (in a single dataset)}
\usage{
evaluate_control_chart_one_group(
  chart_matrix,
  time_matrix,
  nobs,
  starttime,
  endtime,
  status,
  design_interval,
  n_time_units,
  time_unit,
  no_signal_action = "omit"
)
}
\arguments{
\item{chart_matrix}{charting statistics arranged as a numeric matrix. \cr
\code{chart_matrix[i,j]} is the jth charting statistic of the ith subject.}

\item{time_matrix}{observation times arranged as a numeric matrix. \cr
\code{time_matrix[i,j]} is the jth observation time of the ith subject. \cr
\code{chart_matrix[i,j]} is the charting statistic of the ith subject at \code{time_matrix[i,j]}.}

\item{nobs}{number of observations arranged as an integer vector. \cr
\code{nobs[i]} is the number of observations for the ith subject.}

\item{starttime}{a numeric vector.
\code{starttime[i]} is the time when monitoring starts for ith subject.}

\item{endtime}{a numeric vector, times when monitoring end.
\code{endtime[i]} is the time when monitoring ends for ith subject.}

\item{status}{a logical vector.
\code{status[i]=FALSE} if the ith subject is IC, while \code{status[i]=TRUE} indicates the the ith subject is OC.}

\item{design_interval}{a numeric vector of length two that 
gives the left- and right- limits of the design interval. 
By default, \code{design_interval=range(time_matrix,na.rm=TRUE)}.}

\item{n_time_units}{an integer value that gives the number of basic time units
in the design time interval. \cr
The design interval will be discretized to \code{seq(design_interval[1],design_interval[2],length.out=n_time_units)}}

\item{time_unit}{an optional numeric value of basic time unit. Only used when \code{n_time_units} is missing.\cr
The design interval will be discretized to \code{seq(design_interval[1],design_interval[2],by=time_unit)}}

\item{no_signal_action}{a character value specifying how to set signal times when processes with no signals.\cr
If \code{no_signal_action=="omit"}, the signal time is set to be missing.\cr
If \code{no_signal_action=="maxtime"}, the signal time is set to be the time from start time to the end of the design interval.\cr
If \code{no_signal_action=="endtime"}, the signal time is set to be the time from start time to the end time.\cr}
}
\value{
an list that stores the evaluation measures. \cr
\item{$thres}{A numeric vector. Threshold values for control limits.}
\item{$FPR}{A numeric vector. False positive rates.}
\item{$TPR}{A numeric vector. True positive rates.}
\item{$ATS0}{A numeric vector. In-control ATS.}
\item{$ATS1}{A numeric vector. Out-of-control ATS.}
}
\description{
The function \code{evaluate_control_chart_one_group} evaluates a control chart when
the in-control (IC) and out-of-control (OC) charting statistics are supplied together in one matrix \code{chart_matrix}.
The logical vector \code{status} indicates if the ith subject is IC or OC.
}
\details{
Evaluate Control Charts
}
\examples{
result_pattern<-estimate_pattern_long_surv(
  data_array=data_example_long_surv$data_array_IC,
  time_matrix=data_example_long_surv$time_matrix_IC,
  nobs=data_example_long_surv$nobs_IC,
  starttime=data_example_long_surv$starttime_IC,
  survtime=data_example_long_surv$survtime_IC,
  survevent=data_example_long_surv$survevent_IC,
  design_interval=data_example_long_surv$design_interval,
  n_time_units=data_example_long_surv$n_time_units,
  estimation_method="risk",
  smoothing_method="local linear",
  bw_beta=0.05,
  bw_mean=0.1,
  bw_var=0.1)

result_monitoring<-monitor_long_surv(
  data_array_new=data_example_long_surv$data_array_IC,
  time_matrix_new=data_example_long_surv$time_matrix_IC,
  nobs_new=data_example_long_surv$nobs_IC,
  pattern=result_pattern,
  method="risk",
  parameter=0.5)

output_evaluate<-evaluate_control_chart_one_group(
  chart_matrix=result_monitoring$chart[1:200,],
  time_matrix=data_example_long_surv$time_matrix_IC[1:200,],
  nobs=data_example_long_surv$nobs_IC[1:200],
  starttime=rep(0,200),
  endtime=rep(1,200),
  status=data_example_long_surv$survevent_IC[1:200],
  design_interval=data_example_long_surv$design_interval,
  n_time_units=data_example_long_surv$n_time_units,
  no_signal_action="maxtime")

}
\references{
Qiu, P. and Xiang, D. (2014). Univariate dynamic screening system: an approach for identifying individuals with irregular longitudinal behavior. Technometrics, 56:248-260. \cr
Qiu, P., Xia, Z., and You, L. (2020). Process monitoring ROC curve for evaluating dynamic screening methods. Technometrics, 62(2).
}
