% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnosis.R
\name{apply_dia}
\alias{apply_dia}
\title{Apply a Trained Diagnostic Model to New Data}
\usage{
apply_dia(
  trained_model_object,
  new_data,
  label_col_name = NULL,
  pos_class,
  neg_class
)
}
\arguments{
\item{trained_model_object}{A trained model object, as returned by \code{models_dia},
\code{bagging_dia}, \code{stacking_dia}, \code{voting_dia}, or \code{imbalance_dia}.}

\item{new_data}{A data frame containing the new data for prediction. The first
column must be the sample ID, subsequent columns are features.}

\item{label_col_name}{A character string, the name of the column containing
the class labels in the new data. This is optional and only used
to include true labels in the output; it is not used for prediction.}

\item{pos_class}{A character string, the label for the positive class (must
match the label used during training).}

\item{neg_class}{A character string, the label for the negative class (must
match the label used during training).}
}
\value{
A data frame with \code{sample} (ID), \code{label} (original numeric label from
new data, or NA if not provided), and \code{score} (predicted probability for the positive class).
}
\description{
Applies a previously trained model (or ensemble) to a new, unseen
dataset to generate predicted probabilities.
}
\examples{
\donttest{
# 1. Assume 'train_dia' and 'test_dia' are loaded from your package
# data(train_dia)
# data(test_dia) # test_dia has same structure, maybe without the label column
initialize_modeling_system_dia()

# 2. Train a model
train_results <- models_dia(
  data = train_dia, model = "lasso",
  new_positive_label = "Case", new_negative_label = "Control"
)
trained_lasso_model <- train_results$lasso$model_object

# 3. Apply the trained model to new data
new_predictions <- apply_dia(
  trained_model_object = trained_lasso_model,
  new_data = test_dia,
  label_col_name = "Disease_Status", # Optional
  pos_class = "Case",
  neg_class = "Control"
)
utils::head(new_predictions)
}
}
