% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integrate.R
\name{plot_integrated_results}
\alias{plot_integrated_results}
\title{Visualize Integrated Modeling Results}
\usage{
plot_integrated_results(results_obj, metric_name = "AUROC", output_file = NULL)
}
\arguments{
\item{results_obj}{Output from \code{int_dia}, \code{int_imbalance}, or \code{int_pro}.}

\item{metric_name}{Character string for metric used (e.g., "AUROC", "C-index").}

\item{output_file}{Optional file path to save plot. If NULL, plot is displayed.}
}
\value{
A ggplot object (invisibly).
}
\description{
Creates a heatmap visualization with performance metrics across
models and datasets, including category annotations and summary bar plots.
}
\examples{
\dontrun{
results <- int_dia(train_dia, test_dia)
plot_integrated_results(results, "AUROC")
}

}
