% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VAR_INMB.R
\name{create_object_var_inmb}
\alias{create_object_var_inmb}
\title{Create an object var_inmb}
\usage{
create_object_var_inmb(sdc, sde, rho, object_lambda)
}
\arguments{
\item{sdc}{: common standard deviation of costs in each group}

\item{sde}{: common standard deviation of effectiveness in each group}

\item{rho}{: coefficient of correlation between the difference in costs (dc) and the difference in effectiveness (de)}

\item{object_lambda}{: an object lambda.
Create one with \link{create_object_lambda}.
It contains lambda : the ceiling cost-effectiveness ratio or maximum acceptable cost of a unit of effectiveness}
}
\value{
create_object_var_inmb returns an object of class \link{VAR_INMB} which inherits from the class \link{VAR_INMB_DIRECT}
}
\description{
Hypothetical variance of the Incremental Net Monetary Benefit.
If data are available this variance can be calculated based of the common standard deviation of costs in each group (sdc),
the common standard deviation of effectiveness in each group (sde), lambda (\link{create_object_lambda}),
and the coefficient of correlation (rho) between the difference in costs (dc) and the difference in effectiveness (de)
}
\examples{
## First, create a lambda object
object_lambda <- create_object_lambda (20000)
## Then, create a var_inmb object
var_inmb <- create_object_var_inmb(sde=0.12, sdc=2100, rho=0.1, object_lambda=object_lambda)
var_inmb$get_var_inmb()
}
\seealso{
\link{create_object_var_inmb_direct} to directly provide a value for the variance of the Incremental Net Monetary Benefit

\link{create_object_var_inmb_diff} to calculate the theoretical standard deviation of the expected INB with different standard deviation in the reference and the experimental group
}

