% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ECSFargateProvider-method.R
\name{ECSFargateProvider}
\alias{ECSFargateProvider}
\title{Create an ECS Fargate cloud provider}
\usage{
ECSFargateProvider(
  clusterName = "R-worker-cluster",
  serverTaskDefName = "R-server-task-definition",
  workerTaskDefName = "R-worker-task-definition",
  securityGroupName = "R-parallel-security-group",
  vpcId = NULL,
  subnetId = NULL,
  securityGroupId = NULL,
  internetGatewayId = NULL,
  routeTableId = NULL,
  taskExecRoleId = NULL,
  enableWorkerPublicIp = TRUE,
  logDriver = c("auto", "none", "awslogs", "awsfirelens", "splunk"),
  logOptions = list(),
  region = aws.ecx::aws_get_region()
)
}
\arguments{
\item{clusterName}{Character, the cluster name in ECS Fargate}

\item{serverTaskDefName, workerTaskDefName}{Character, the task defintion name for
the server and worker}

\item{securityGroupName}{Character, the security group name}

\item{vpcId, subnetId, securityGroupId, internetGatewayId, routeTableId, taskExecRoleId}{The ID/ARN
of the resources for the container}

\item{enableWorkerPublicIp}{Logical, whether to enable the public IP for the worker.
If this value is \code{FALSE}, the worker will not be able to pull the container image from the
public network}

\item{logDriver}{Character, the log driver, if \code{logDriver = "auto"}, the awslogs will be used}

\item{logOptions}{Named list, the options for the log driver}

\item{region}{Character, the region of the ECS computing cluster}
}
\value{
a \code{ECSFargateProvider} object
}
\description{
Create an ECS Fargate cloud provider. Note that the arguments for the function
are the settings for ECS fargate. You can find them in the AWS ECS console.
}
\examples{
provider <- ECSFargateProvider()
}
