% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_data_package_error.R
\name{read_data_package_error}
\alias{read_data_package_error}
\title{Read data package error}
\usage{
read_data_package_error(transaction, env = "production")
}
\arguments{
\item{transaction}{(character) Transaction identifier}

\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
An error is returned if an error occurred while processing the
request, otherwise \code{NULL} is returned if no error was encountered or if
processing is still underway.
}
\description{
Read data package error
}
\note{
User authentication is required (see \code{login()})
}
\examples{
\dontrun{

# Create zip archive
packageId <- "knb-lter-sev.31999.1"
transaction <- create_data_package_archive(packageId)
transaction
#> [1] "archive_knb-lter-sev.31999.1_16396683904724129"

# Check creation status
read_data_package_error(transaction)

# Download zip archive
read_data_package_archive(packageId, transaction, path = tempdir())
#> |=============================================================| 100\%
dir(tempdir())
#> [1] "knb-lter-sev.31999.1.zip"
}

}
\seealso{
Other Accessing: 
\code{\link{read_data_entity_checksum}()},
\code{\link{read_data_entity_names}()},
\code{\link{read_data_entity_name}()},
\code{\link{read_data_entity_resource_metadata}()},
\code{\link{read_data_entity_sizes}()},
\code{\link{read_data_entity_size}()},
\code{\link{read_data_entity}()},
\code{\link{read_data_package_archive}()},
\code{\link{read_data_package_citation}()},
\code{\link{read_data_package_doi}()},
\code{\link{read_data_package_from_doi}()},
\code{\link{read_data_package_report_checksum}()},
\code{\link{read_data_package_report_resource_metadata}()},
\code{\link{read_data_package_report_summary}()},
\code{\link{read_data_package_report}()},
\code{\link{read_data_package_resource_metadata}()},
\code{\link{read_data_package}()},
\code{\link{read_evaluate_report_summary}()},
\code{\link{read_evaluate_report}()},
\code{\link{read_metadata_checksum}()},
\code{\link{read_metadata_dublin_core}()},
\code{\link{read_metadata_entity}()},
\code{\link{read_metadata_format}()},
\code{\link{read_metadata_resource_metadata}()},
\code{\link{read_metadata}()}
}
\concept{Accessing}
