% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.EFAkmeans}
\alias{plot.EFAkmeans}
\title{Plot EFA K-means Clustering Results}
\usage{
\method{plot}{EFAkmeans}(x, ...)
}
\arguments{
\item{x}{An object of class \code{EFAkmeans}, representing the results to be plotted.}

\item{...}{Additional arguments to be passed to the plotting function.}
}
\value{
None. This function is used for side effects (plotting).
}
\description{
This function creates a plot to visualize the Within-cluster Sum of Squares (WSS) for different numbers of clusters (K)
in the context of exploratory factor analysis. The plot helps identify the most appropriate number of factors by showing
how WSS decreases as the number of factors (or clusters) increases.
}
\examples{
library(EFAfactors)
set.seed(123)

## Take the data.bfi dataset as an example.
data(data.bfi)

response <- as.matrix(data.bfi[, 1:25]) ## Load data
response <- na.omit(response) ## Remove samples with NA/missing values

## Transform the scores of reverse-scored items to normal scoring
response[, c(1, 9, 10, 11, 12, 22, 25)] <- 6 - response[, c(1, 9, 10, 11, 12, 22, 25)] + 1

\donttest{
  EFAkmeans.obj <- EFAkmeans(response)

  ## Plot the EFA K-means clustering results
  plot(EFAkmeans.obj)
}

}
\seealso{
\link[EFAfactors]{EFAkmeans}
}
