% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.EGA.R
\name{plot.EGA}
\alias{plot.EGA}
\title{Plot method for \code{\link[EGAnet]{EGA}}objects}
\usage{
\method{plot}{EGA}(x, title = "", vsize = 6, ...)
}
\arguments{
\item{x}{An \code{\link[EGAnet]{EGA}} object}

\item{title}{Character. Title of the plot}

\item{vsize}{An integer indicating the size of the nodes.
Default vsize = 6}

\item{...}{Arguments passed to \code{\link[qgraph]{qgraph}}}
}
\description{
Plots the \code{\link[EGAnet]{EGA}} result using \code{\link[qgraph]{qgraph}}
}
\examples{
\dontrun{
# Estimate EGA
ega.wmt <- EGA(data = wmt2[,7:24], plot.EGA = TRUE)

}

# Summary of EGA results
summary(ega.wmt)

# Plot EGA network
plot(ega.wmt, vsize = 6, label.prop = 1)

}
\seealso{
\code{\link[EGAnet]{EGA}} to estimate the number of dimensions of an instrument using EGA
and \code{\link[EGAnet]{CFA}} to verify the fit of the structure suggested by EGA using confirmatory factor analysis.
}
\author{
Hudson F. Golino <hfg9s at virginia.edu>
}
