% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/louvain.R
\name{louvain}
\alias{louvain}
\title{Louvain Community Detection Algorithm}
\usage{
louvain(A, method = c("modularity", "tefi"), resolution = 1, corr = NULL)
}
\arguments{
\item{A}{Matrix or data frame.
A network adjacency matrix}

\item{method}{Character.
Whether modularity or \code{\link[EGAnet]{tefi}} should
be used to optimize communities.
Defaults to \code{"modularity"}}

\item{resolution}{Numeric.
Resolution parameter for computing modularity.
Defaults to \code{1}.
Values smaller than 1 favor larger communities;
values larger than 1 favor smaller communities}

\item{corr}{Matrix or data frame.
Correlation matrix to be used when \code{method = "tefi"}}
}
\value{
Returns a list containing:

\item{wc}{A matrix of lower to higher order community membership
detected in the network}

\item{modularity}{A vector of modularity values corresponding the rows
of the \code{wc} matrix}
}
\description{
Computes the Louvain community detection algorithm (Blondel et al., 2008)
}
\details{
This version was adapted from the Matlab code available here:
https://perso.uclouvain.be/vincent.blondel/research/louvain.html. The code
was adjusted to mirror the results of \code{\link[igraph]{cluster_louvain}}.
The Louvain algorithm's results can vary depending on node ordering. In this
version, nodes are \strong{not} shuffled so that consistent results can be
achieved with the same node ordering. Results from \code{\link[igraph]{cluster_louvain}}
will shuffle nodes \strong{within} the function and therefore will sometimes produce
similar results and sometimes produce slightly different results. This version
is based all in R and therefore is slower than the version in \code{\link{igraph}}.
}
\examples{
# Load data
dep <- depression[,24:44]

# Estimate correlations
corr <- qgraph::cor_auto(dep)

# Estimate network
net <- EBICglasso.qgraph(corr, n = nrow(dep))

# Estimate communities using modularity
louvain(net, method = "modularity")

# Estimate communities using tefi
louvain(net, method = "tefi", corr = corr)

}
\references{
Blondel, V. D., Guillaume, J.-L., Lambiotte, R., & Lefebvre, E. (2008).
Fast unfolding of communities in large networks.
\emph{Journal of Statistical Mechanics: Theory and Experiment}, \emph{2008}, P10008.
}
\author{
Alexander P. Christensen <alexpaulchristensen@gmail.com> and Hudson Golino <hfg9s@virginia.edu>
}
