% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/populateDaily.r
\name{populateDaily}
\alias{populateDaily}
\title{Populate Daily data frame}
\usage{
populateDaily(rawData, qConvert, interactive = TRUE)
}
\arguments{
\item{rawData}{dataframe contains at least dateTime, value, code columns}

\item{qConvert}{character conversion to cubic meters per second}

\item{interactive}{logical Option for interactive mode.  If true, there is user interaction for error handling and data checks.}
}
\value{
A data frame 'Daily' with the following columns:
\tabular{lll}{
Name \tab Type \tab Description \cr
Q \tab numeric \tab Discharge in m^3/s\cr
Julian \tab integer \tab Number of days since Jan. 1, 1850\cr
Month \tab integer \tab Month of the year [1-12] \cr
Day \tab integer \tab Day of the year [1-366] \cr
DecYear \tab numeric \tab Decimal year \cr
MonthSeq \tab integer \tab Number of months since January 1, 1850 \cr
Qualifier \tab character \tab Qualifying code \cr
i \tab integer \tab Index of days, starting with 1 \cr
LogQ \tab numeric \tab Natural logarithm of Q  \cr
Q7 \tab numeric \tab 7 day running average of Q \cr
Q30 \tab numeric \tab 30 day running average of Q \cr
}
}
\description{
Using raw data that has at least dateTime, value, code, populates the rest of the basic Daily data frame used in WRTDS
}
\examples{
dateTime <- as.character(seq(as.Date("2001/1/1"),
         as.Date("2001/12/31"), by = "day"))
value <- 1:365
code <- rep("",365)
dataInput <- data.frame(dateTime, value, code, stringsAsFactors=FALSE)
Daily <- populateDaily(dataInput, 2)
}
\author{
Robert M. Hirsch \email{rhirsch@usgs.gov}
}
\seealso{
\code{\link{readNWISDaily}}, \code{\link{readUserDaily}}
}
\keyword{WRTDS}
\keyword{flow}

