% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeReport.r
\name{mergeReport}
\alias{mergeReport}
\title{mergeReport}
\usage{
mergeReport(INFO, Daily, Sample = NA, surfaces = NA, verbose = TRUE,
  interactive = NULL)
}
\arguments{
\item{INFO}{dataframe metadata about the Sample and Daily data frames.}

\item{Daily}{dataframe containing the daily discharge data}

\item{Sample}{dataframe containing the sample data}

\item{surfaces}{matrix returned from \code{\link{modelEstimation}}. Default is NA.}

\item{verbose}{logical specifying whether or not to display summary information on 
the Daily and Sample dataframes.}

\item{interactive}{logical deprecated. Use 'verbose' instead}
}
\value{
eList named list with Daily, Sample, and INFO dataframes, along with the surfaces matrix.
Any of these values can be NA, not all EGRET functions will work with missing parts of the named list eList.
}
\description{
This function does three things.  1) It transfers the daily discharge value 
from the Daily data frame to to Sample data frame for those days with samples.
2) It merges the INFO, Daily and Sample data frames to form an eList object, 
3) and it prints out a "report" of basic information about the Daily and 
Sample data frames.
}
\details{
Note that the Sample dataframe in the global environment does 
not update with the flow information.
}
\examples{

siteNumber <- '01491000'
pCode <- '00631'
\dontrun{
Daily <- readNWISDaily(siteNumber,'00060', '1984-10-01', '')
Sample <- readNWISSample(siteNumber,pCode, '1984-10-01', '')
INFO <- readNWISInfo(siteNumber,pCode,interactive=FALSE)
eList <- mergeReport(INFO, Daily, Sample)
Sample <- eList$Sample
plot(eList)

# Create eList with no water quality data:

eList <- mergeReport(INFO, Daily, Sample = NA)
plotFour(eList)
}
}
\seealso{
\code{\link{readNWISDaily}}, \code{\link{readNWISSample}}
}
\keyword{USGS}
\keyword{WRTDS}
\keyword{data}
\keyword{import}
