% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fluxBiasEight.R
\name{fluxBiasMulti}
\alias{fluxBiasMulti}
\title{Produces 8-panel plot that is useful for determining if there is a flux bias problem}
\usage{
fluxBiasMulti(eList, qUnit = 2, fluxUnit = 3, moreTitle = "WRTDS",
  cex = 0.7, cex.axis = 1.1, cex.main = 1.1, randomCensored = FALSE,
  col = "black", lwd = 1, ...)
}
\arguments{
\item{eList}{named list with at least Sample, Daily, and INFO dataframes}

\item{qUnit}{object of qUnit class. \code{\link{printqUnitCheatSheet}}, or numeric represented the short code, or character representing the descriptive name.}

\item{fluxUnit}{object of fluxUnit class. \code{\link{printFluxUnitCheatSheet}}, or numeric represented the short code, or character representing the descriptive name.}

\item{moreTitle}{character specifying some additional information to go in figure title, typically some information about the specific estimation method used, default is no additional information}

\item{cex}{numerical value giving the amount by which plotting symbols should be magnified}

\item{cex.axis}{magnification to be used for axis annotation relative to the current setting of cex}

\item{cex.main}{magnification to be used for main titles relative to the current setting of cex}

\item{randomCensored}{logical, if TRUE plot a random value for censored data.  Default is FALSE.}

\item{col}{color of points on plot, see ?par 'Color Specification'}

\item{lwd}{number line width}

\item{\dots}{arbitrary graphical parameters that will be passed to genericEGRETDotPlot function (see ?par for options)}
}
\description{
These plots use the jack-knife estimates from WRTDS to investigate the potential flux bias problem. 
It can also be used for estimates constructed by other methods (such as LOADEST) if the results are
stored in a data frame organized like the Sample data frame.  It allows additional label information
to indicate what method is used. The use of this plot is described in Hirsch, Robert M., 2014. 
Large Biases in Regression-Based Constituent Flux Estimates: Causes and Diagnostic
Tools. Journal of the American Water Resources Association (JAWRA) 1-24. DOI: 10.1111/jawr.12195


Although there are a lot of optional arguments to this function, most are set to a logical default. 

Data come from named list, which contains a Sample dataframe with the sample data, 
a Daily dataframe with the daily flow data, and an INFO dataframe with metadata.
}
\examples{
eList <- Choptank_eList
# Water year:
fluxBiasMulti(eList)
fluxBiasMulti(eList, fluxUnit = 2)
# Graphs consisting of Jun-Aug
eList <- setPA(eList,paStart=6,paLong=3)
fluxBiasMulti(eList)
}
\keyword{graphics}
\keyword{statistics}
\keyword{water-quality}
